package org.me;

import java.util.Date;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;

@MessageDriven(activationConfig = {
		@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
		@ActivationConfigProperty(propertyName = "destination", propertyValue = "java:/jms/queue/InvalidQueue, java:jboss/exported/InvalidQueue") })
public class InvalidHandler implements MessageListener {

	@Override
	public void onMessage(Message message) {
		try {
			if (message instanceof MapMessage) {
				System.out.println("Az zenet ekkor megrkezett (InvalidQueue): " + new Date());
				Thread.sleep(5000);
				sendBack(message);
				System.out.println("zenet elkldve az InvalidQueue-ra");
			} else {
				System.out.println("hibs zenet");
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}

	private void sendBack(Message message) {
		InitialContext initialContext = null;
		try {
			initialContext = new InitialContext();
			QueueConnectionFactory qconFactory = (QueueConnectionFactory) initialContext
					.lookup("java:jboss/DefaultJMSConnectionFactory");
			QueueConnection qcon = qconFactory.createQueueConnection();
			QueueSession qsession = qcon.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
			Queue queue = (Queue) initialContext.lookup("java:/jms/queue/TaskQueue");
			QueueSender qsender = qsession.createSender(queue);
			qcon.start();
			qsender.send(message);
			qsender.close();
			qsession.close();
			qcon.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
