/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.AttributeBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.generate.AbstractGenerator;
import com.sun.faces.generate.Generator;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.JspTLDGenerator;
import com.sun.faces.generate.PropertyManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HtmlTaglib12Generator
extends AbstractGenerator {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.config.generate", "com.sun.faces.ToolsLogStrings");
    protected AbstractGenerator.CodeWriter writer;
    protected ComponentBean component = null;
    protected RendererBean renderer = null;
    protected String tagClassName = null;
    protected FacesConfigBean configBean;
    protected PropertyManager propManager;
    private Generator tldGenerator;
    private File outputDir;
    private List<String> imports;

    public HtmlTaglib12Generator(PropertyManager propManager) {
        this.propManager = propManager;
        this.outputDir = this.getClassPackageDirectory();
        this.setTldGenerator(GeneratorUtil.getTldGenerator(propManager));
        this.addImport("com.sun.faces.util.Util");
        this.addImport("java.io.IOException");
        this.addImport("javax.faces.component.*");
        this.addImport("javax.faces.context.*");
        this.addImport("javax.faces.convert.*");
        this.addImport("javax.faces.el.*");
        this.addImport("javax.faces.webapp.*");
        this.addImport("javax.servlet.jsp.JspException");
    }

    @Override
    public void generate(FacesConfigBean configBean) {
        this.configBean = configBean;
        try {
            this.generateTagClasses();
            this.tldGenerator.generate(configBean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        PropertyManager manager = PropertyManager.newInstance(args[0]);
        try {
            HtmlTaglib12Generator generator = new HtmlTaglib12Generator(manager);
            generator.generate(GeneratorUtil.getConfigBean(args[1]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setTldGenerator(JspTLDGenerator tldGenerator) {
        this.tldGenerator = tldGenerator;
    }

    protected void addImport(String fullyQualClassName) {
        if (this.imports == null) {
            this.imports = new ArrayList<String>();
        }
        this.imports.add(fullyQualClassName);
    }

    protected void writeImports() throws Exception {
        Collections.sort(this.imports);
        Iterator<String> i = this.imports.iterator();
        while (i.hasNext()) {
            this.writer.writeImport(i.next());
        }
    }

    protected void writeCopyright() throws Exception {
        this.writer.writeBlockComment(this.propManager.getProperty("copyright"));
    }

    protected void writePackage() throws Exception {
        this.writer.writePackage(this.propManager.getProperty("target.package"));
    }

    protected void writeClassDocumentation() throws Exception {
        DescriptionBean db = this.component.getDescription("");
        if (db != null) {
            String description = db.getDescription();
            if (description == null) {
                description = "";
            }
            if ((description = description.trim()).length() > 0) {
                this.writer.writeJavadocComment(description);
            }
        }
    }

    protected void writeClassDeclaration() throws Exception {
        this.writer.writePublicClassDeclaration(this.tagClassName, "UIComponentELTag", null, false, true);
    }

    protected void tagHandlerPrefix() throws Exception {
        this.writeCopyright();
        this.writer.write(10);
        this.writePackage();
        this.writer.write(10);
        this.writeImports();
        this.writer.write("\n\n");
        this.writer.writeBlockComment("******* GENERATED CODE - DO NOT EDIT *******");
        this.writer.write("\n\n");
        this.writeClassDocumentation();
        this.writeClassDeclaration();
        this.writer.write(10);
        this.writer.indent();
    }

    protected void tagHandlerReleaseMethod() throws Exception {
        this.writer.writeLineComment("RELEASE");
        this.writer.fwrite("public void release() {\n");
        this.writer.indent();
        this.writer.fwrite("super.release();\n\n");
        this.writer.writeLineComment("component properties");
        for (PropertyBean property : this.component.getProperties()) {
            if (property == null || !property.isTagAttribute()) continue;
            String propertyName = property.getPropertyName();
            String propertyType = property.getPropertyClass();
            if ("binding".equals(propertyName) || "id".equals(propertyName) || "rendered".equals(propertyName)) continue;
            String ivar = HtmlTaglib12Generator.mangle(propertyName);
            this.writer.fwrite("this." + ivar + " = ");
            if (HtmlTaglib12Generator.primitive(propertyType) && !property.isValueExpressionEnabled() && !property.isMethodExpressionEnabled()) {
                this.writer.write((String)TYPE_DEFAULTS.get(propertyType));
            } else {
                this.writer.write("null");
            }
            this.writer.write(";\n");
        }
        this.writer.write("\n");
        this.writer.writeLineComment("rendered attributes");
        for (AttributeBean attribute : this.renderer.getAttributes()) {
            if (attribute == null || !attribute.isTagAttribute()) continue;
            String attributeName = attribute.getAttributeName();
            this.writer.fwrite("this." + HtmlTaglib12Generator.mangle(attributeName) + " = null;\n");
        }
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
    }

    protected void tagHandlerSetterMethods() throws Exception {
        this.writer.writeLineComment("Setter Methods");
        for (PropertyBean property : this.component.getProperties()) {
            if (property == null || !property.isTagAttribute()) continue;
            String propertyName = property.getPropertyName();
            String propertyType = property.getPropertyClass();
            if ("binding".equals(propertyName) || "id".equals(propertyName) || "rendered".equals(propertyName)) continue;
            if (property.isValueExpressionEnabled() || property.isMethodExpressionEnabled()) {
                this.writer.writeWriteOnlyProperty(propertyName, "java.lang.String");
                continue;
            }
            this.writer.writeWriteOnlyProperty(propertyName, propertyType);
        }
        for (AttributeBean attribute : this.renderer.getAttributes()) {
            if (attribute == null || !attribute.isTagAttribute()) continue;
            String attributeName = attribute.getAttributeName();
            this.writer.writeWriteOnlyProperty(attributeName, "java.lang.String");
        }
        this.writer.write("\n");
    }

    protected void tagHanderSetPropertiesMethod() throws Exception {
        String componentType = this.component.getComponentType();
        String componentClass = this.component.getComponentClass();
        this.writer.fwrite("protected void setProperties(UIComponent component) {\n");
        this.writer.indent();
        this.writer.fwrite("super.setProperties(component);\n");
        String iVar = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
        this.writer.fwrite(componentClass + ' ' + iVar + " = null;\n");
        this.writer.fwrite("try {\n");
        this.writer.indent();
        this.writer.fwrite(iVar + " = (" + componentClass + ") component;\n");
        this.writer.outdent();
        this.writer.fwrite("} catch (ClassCastException cce) {\n");
        this.writer.indent();
        this.writer.fwrite("throw new IllegalStateException(\"Component \" + component.toString() + \" not expected type.  Expected: " + componentClass + ".  Perhaps you're missing a tag?\");\n");
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        if (HtmlTaglib12Generator.isValueHolder(componentClass)) {
            this.writer.fwrite("if (converter != null) {\n");
            this.writer.indent();
            this.writer.fwrite("if (isValueReference(converter)) {\n");
            this.writer.indent();
            this.writer.fwrite("ValueBinding vb = Util.getValueBinding(converter);\n");
            this.writer.fwrite(iVar + ".setValueBinding(\"converter\", vb);\n");
            this.writer.outdent();
            this.writer.fwrite("} else {\n");
            this.writer.indent();
            this.writer.fwrite("Converter _converter = FacesContext.getCurrentInstance().getApplication().createConverter(converter);\n");
            this.writer.fwrite(iVar + ".setConverter(_converter);\n");
            this.writer.outdent();
            this.writer.fwrite("}\n");
            this.writer.outdent();
            this.writer.fwrite("}\n\n");
        }
        for (PropertyBean property : this.component.getProperties()) {
            String ivar;
            if (property == null || !property.isTagAttribute()) continue;
            String propertyName = property.getPropertyName();
            String propertyType = property.getPropertyClass();
            if ("binding".equals(propertyName) || "id".equals(propertyName) || "rendered".equals(propertyName) || "converter".equals(propertyName)) continue;
            String vbKey = ivar = HtmlTaglib12Generator.mangle(propertyName);
            String comp = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
            String capPropName = HtmlTaglib12Generator.capitalize(propertyName);
            if (property.isValueExpressionEnabled()) {
                this.writer.fwrite("if (" + ivar + " != null) {\n");
                this.writer.indent();
                this.writer.fwrite("if (isValueReference(" + ivar + ")) {\n");
                this.writer.indent();
                this.writer.fwrite("ValueBinding vb = Util.getValueBinding(" + ivar + ");\n");
                this.writer.fwrite(comp + ".setValueBinding(\"" + vbKey + "\", vb);\n");
                this.writer.outdent();
                this.writer.fwrite("} else {\n");
                this.writer.indent();
                if (HtmlTaglib12Generator.primitive(propertyType)) {
                    this.writer.fwrite(comp + ".set" + capPropName + "(" + GeneratorUtil.convertToPrimitive(propertyType) + ".valueOf(" + ivar + ")." + propertyType + "Value());\n");
                } else {
                    this.writer.fwrite(comp + ".set" + capPropName + '(' + ivar + ");\n");
                }
                this.writer.outdent();
                this.writer.fwrite("}\n");
                this.writer.outdent();
                this.writer.fwrite("}\n\n");
                continue;
            }
            if (property.isMethodExpressionEnabled()) {
                if ("action".equals(ivar)) {
                    this.writer.fwrite("if (" + ivar + " != null) {\n");
                    this.writer.indent();
                    this.writer.fwrite("if (isValueReference(" + ivar + ")) {\n");
                    this.writer.indent();
                    this.writer.fwrite("MethodBinding vb = FacesContext.getCurrentInstance().");
                    this.writer.write("getApplication().createMethodBinding(" + ivar + ", null);\n");
                    this.writer.fwrite(comp + ".setAction(vb);\n");
                    this.writer.outdent();
                    this.writer.fwrite("} else {\n");
                    this.writer.indent();
                    this.writer.fwrite("final String outcome = " + ivar + ";\n");
                    this.writer.fwrite("MethodBinding vb = Util.createConstantMethodBinding(" + ivar + ");\n");
                    this.writer.fwrite(comp + ".setAction(vb);\n");
                    this.writer.outdent();
                    this.writer.fwrite("}\n");
                    this.writer.outdent();
                    this.writer.fwrite("}\n");
                    continue;
                }
                HashMap<String, String> signatureMap = new HashMap<String, String>(3);
                signatureMap.put("actionListener", "Class args[] = { ActionEvent.class };");
                signatureMap.put("validator", "Class args[] = { FacesContext.class, UIComponent.class, Object.class };");
                signatureMap.put("valueChangeListener", "Class args[] = { ValueChangeEvent.class };");
                this.writer.fwrite("if (" + ivar + " != null) {\n");
                this.writer.indent();
                this.writer.fwrite("if (isValueReference(" + ivar + ")) {\n");
                this.writer.indent();
                this.writer.fwrite((String)signatureMap.get(ivar) + "\n");
                this.writer.fwrite("MethodBinding vb = FacesContext.getCurrentInstance().");
                this.writer.write("getApplication().createMethodBinding(" + ivar + ", args);\n");
                this.writer.fwrite(comp + ".set" + HtmlTaglib12Generator.capitalize(ivar) + "(vb);\n");
                this.writer.outdent();
                this.writer.fwrite("} else {\n");
                this.writer.indent();
                this.writer.fwrite("Object params [] = {" + ivar + "};\n");
                this.writer.fwrite("throw new javax.faces.FacesException(Util.getExceptionMessageString(Util.INVALID_EXPRESSION_ID, params));\n");
                this.writer.outdent();
                this.writer.fwrite("}\n");
                this.writer.outdent();
                this.writer.fwrite("}\n");
                continue;
            }
            this.writer.fwrite(comp + ".set" + capPropName + "(" + ivar + ");\n");
        }
        for (AttributeBean attribute : this.renderer.getAttributes()) {
            String ivar;
            if (attribute == null || !attribute.isTagAttribute()) continue;
            String attributeName = attribute.getAttributeName();
            String attributeType = attribute.getAttributeClass();
            String vbKey = ivar = HtmlTaglib12Generator.mangle(attributeName);
            String comp = GeneratorUtil.stripJavaxFacesPrefix(componentType).toLowerCase();
            this.writer.fwrite("if (" + ivar + " != null) {\n");
            this.writer.indent();
            this.writer.fwrite("if (isValueReference(" + ivar + ")) {\n");
            this.writer.indent();
            this.writer.fwrite("ValueBinding vb = Util.getValueBinding(" + ivar + ");\n");
            this.writer.fwrite(comp);
            if ("_for".equals(ivar)) {
                this.writer.write(".setValueBinding(\"_" + vbKey + "\", vb);\n");
            } else {
                this.writer.write(".setValueBinding(\"" + vbKey + "\", vb);\n");
            }
            this.writer.outdent();
            this.writer.fwrite("} else {\n");
            this.writer.indent();
            if (HtmlTaglib12Generator.primitive(attributeType)) {
                this.writer.fwrite(comp + ".getAttributes().put(\"" + ivar + "\", ");
                this.writer.write(GeneratorUtil.convertToPrimitive(attributeType) + ".valueOf(" + ivar + "));\n");
            } else {
                if ("bundle".equals(ivar)) {
                    this.writer.fwrite(comp + ".getAttributes().put(com.sun.faces.RIConstants.BUNDLE_ATTR, ");
                } else if ("_for".equals(ivar)) {
                    this.writer.fwrite(comp + ".getAttributes().put(\"for\", ");
                } else {
                    this.writer.fwrite(comp + ".getAttributes().put(\"" + ivar + "\", ");
                }
                this.writer.write(ivar + ");\n");
            }
            this.writer.outdent();
            this.writer.fwrite("}\n");
            this.writer.outdent();
            this.writer.fwrite("}\n");
        }
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
    }

    protected void tagHandlerGeneralMethods() throws Exception {
        this.writer.writeLineComment("General Methods");
        String rendererType = this.renderer.getRendererType();
        String componentType = this.component.getComponentType();
        this.writer.fwrite("public String getRendererType() {\n");
        this.writer.indent();
        this.writer.fwrite("return ");
        this.writer.write('\"' + rendererType + "\";\n");
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        this.writer.fwrite("public String getComponentType() {\n");
        this.writer.indent();
        this.writer.fwrite("return ");
        if (componentType.equals(rendererType)) {
            this.writer.write("\"javax.faces.Html" + GeneratorUtil.stripJavaxFacesPrefix(componentType) + "\";\n");
        } else {
            this.writer.write("\"javax.faces.Html" + GeneratorUtil.stripJavaxFacesPrefix(componentType) + GeneratorUtil.stripJavaxFacesPrefix(rendererType) + "\";\n");
        }
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
    }

    protected static boolean isValueHolder(String componentClass) {
        String[] valueHolderClasses = new String[]{"HtmlBody", "HtmlDoctype", "HtmlHead", "HtmlInputHidden", "HtmlInputSecret", "HtmlInputFile", "HtmlInputText", "HtmlInputTextarea", "HtmlOutcomeTargetButton", "HtmlOutcomeTargetLink", "HtmlOutputFormat", "HtmlOutputLabel", "HtmlOutputLink", "HtmlOutputText", "HtmlSelectBooleanCheckbox", "HtmlSelectManyCheckbox", "HtmlSelectManyListbox", "HtmlSelectManyMenu", "HtmlSelectOneListbox", "HtmlSelectOneMenu", "HtmlSelectOneRadio", "UIInput", "UIOutcomeTarget", "UIOutput", "UISelectBoolean", "UISelectMany", "UISelectOne", "UIViewParameter"};
        boolean result = false;
        for (int i = 0; i < valueHolderClasses.length; ++i) {
            if (!componentClass.endsWith(valueHolderClasses[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void tagHandlerClassicSupportMethods() throws Exception {
        this.writer.writeLineComment("Methods From TagSupport");
        this.writer.fwrite("public int doStartTag() throws JspException {\n");
        this.writer.indent();
        this.writeSuperTagCallBody("doStartTag", true);
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        this.writer.fwrite("public int doEndTag() throws JspException {\n");
        this.writer.indent();
        this.writeSuperTagCallBody("doEndTag", true);
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
    }

    protected void writeSuperTagCallBody(String method, boolean hasReturn) throws IOException {
        this.writer.fwrite("try {\n");
        this.writer.indent();
        this.writer.fwrite(hasReturn ? "return super." : "super.");
        this.writer.write(method);
        this.writer.write("();\n");
        this.writer.outdent();
        this.writer.fwrite("} catch (Exception e) {\n");
        this.writer.indent();
        this.writer.fwrite("Throwable root = e;\n");
        this.writer.fwrite("while (root.getCause() != null) {\n");
        this.writer.indent();
        this.writer.fwrite("root = root.getCause();\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.fwrite("throw new JspException(root);\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
    }

    protected void tagHandlerSuffix() throws Exception {
        this.writer.fwrite("public String getDebugString() {\n");
        this.writer.indent();
        this.writer.fwrite("return \"id: \" + this.getId() + \" class: \" + this.getClass().getName();\n");
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
    }

    private void generateTagClasses() throws Exception {
        Map<String, ArrayList<RendererBean>> renderersByComponentFamily = GeneratorUtil.getComponentFamilyRendererMap(this.configBean, this.propManager.getProperty("renderkit.id"));
        Map<String, ComponentBean> componentsByComponentFamily = GeneratorUtil.getComponentFamilyComponentMap(this.configBean);
        for (Map.Entry<String, ArrayList<RendererBean>> entry : renderersByComponentFamily.entrySet()) {
            String componentFamily = entry.getKey();
            List renderers = entry.getValue();
            this.component = componentsByComponentFamily.get(componentFamily);
            for (RendererBean this.renderer : renderers) {
                String rendererType;
                if (this.renderer.isIgnoreForJsp() || this.renderer.isIgnoreAll() || this.propManager.isExcludeRenderer(rendererType = this.renderer.getRendererType())) continue;
                this.tagClassName = GeneratorUtil.makeTagClassName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType));
                if (this.tagClassName == null) {
                    throw new IllegalStateException("Could not determine tag class name");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Generating " + this.tagClassName + "...");
                }
                File file = new File(this.outputDir, this.tagClassName + ".java");
                this.writer = new AbstractGenerator.CodeWriter(new FileWriter(file));
                this.tagHandlerPrefix();
                this.tagHandlerSetterMethods();
                this.tagHandlerGeneralMethods();
                this.tagHanderSetPropertiesMethod();
                this.tagHandlerClassicSupportMethods();
                this.tagHandlerReleaseMethod();
                this.tagHandlerSuffix();
                this.writer.flush();
                this.writer.close();
            }
        }
    }

    private File getClassPackageDirectory() {
        String packagePath = this.propManager.getProperty("target.package").replace('.', File.separatorChar);
        File packageDir = new File(this.getBaseOutputDirectory(), packagePath);
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        return packageDir;
    }

    private File getBaseOutputDirectory() {
        File outputDir = new File(System.getProperty("user.dir") + File.separatorChar + this.propManager.getProperty("base.output.dir"));
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }
}

