/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.cache;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.cache.CacheProvider;
import org.primefaces.component.cache.UICache;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.renderkit.CoreRenderer;

public class UICacheRenderer
extends CoreRenderer {
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UICache uiCache = (UICache)component;
        if (!uiCache.isDisabled()) {
            String output;
            ResponseWriter writer = context.getResponseWriter();
            CacheProvider cacheProvider = PrimeApplicationContext.getCurrentInstance(context).getCacheProvider();
            String key = uiCache.getKey();
            String region = uiCache.getRegion();
            if (key == null) {
                key = uiCache.getClientId(context);
            }
            if (region == null) {
                region = context.getViewRoot().getViewId();
            }
            if ((output = (String)cacheProvider.get(region, key)) == null) {
                StringWriter stringWriter = new StringWriter();
                ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)stringWriter);
                context.setResponseWriter(clonedWriter);
                this.renderChildren(context, (UIComponent)uiCache);
                output = stringWriter.getBuffer().toString();
                cacheProvider.put(region, key, output);
                context.setResponseWriter(writer);
                uiCache.setCacheSetInCurrentRequest(true);
            }
            writer.write(output);
        } else {
            this.renderChildren(context, (UIComponent)uiCache);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

