/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.divider;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.divider.Divider;
import org.primefaces.renderkit.CoreRenderer;

public class DividerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Divider divider = (Divider)component;
        ResponseWriter writer = context.getResponseWriter();
        String layout = divider.getLayout();
        String align = divider.getAlign();
        String type = divider.getType();
        boolean isHorizontal = "horizontal".equals(layout);
        boolean isVertical = "vertical".equals(layout);
        String styleClass = this.getStyleClassBuilder(context).add("ui-divider ui-widget").add(divider.getStyleClass()).add(isHorizontal, "ui-divider-horizontal").add(isVertical, "ui-divider-vertical").add("solid".equals(type), "ui-divider-solid").add("dashed".equals(type), "ui-divider-dashed").add("dotted".equals(type), "ui-divider-dotted").add(isHorizontal && (align == null || "left".equals(align)), "ui-divider-left").add(isHorizontal && "right".equals(align), "ui-divider-right").add(isHorizontal && "center".equals(align) || isVertical && (align == null || "center".equals(align)), "ui-divider-center").add(isVertical && "top".equals(align), "ui-divider-top").add(isVertical && "bottom".equals(align), "ui-divider-bottom").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)divider.getClientId(context), "id");
        writer.writeAttribute("role", (Object)"separator", "role");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (divider.getStyle() != null) {
            writer.writeAttribute("style", (Object)divider.getStyle(), "style");
        }
        if (divider.getTitle() != null) {
            writer.writeAttribute("title", (Object)divider.getTitle(), "title");
        }
        if (divider.getChildCount() > 0) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-divider-content", "styleClass");
            this.renderChildren(context, (UIComponent)divider);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

