/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.message;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.message.Message;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.WidgetBuilder;

public class MessageRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Message uiMessage = (Message)component;
        UIComponent target = SearchExpressionFacade.resolveComponent(context, (UIComponent)uiMessage, uiMessage.getFor());
        String targetClientId = target.getClientId(context);
        this.encodeMarkup(context, uiMessage, targetClientId);
        this.encodeScript(context, uiMessage, target);
    }

    protected void encodeMarkup(FacesContext context, Message uiMessage, String targetClientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String display = uiMessage.getDisplay();
        boolean iconOnly = "icon".equals(display);
        String style = uiMessage.getStyle();
        String containerClass = "tooltip".equals(display) ? "ui-message ui-helper-hidden" : "ui-message";
        String styleClass = uiMessage.getStyleClass();
        styleClass = styleClass == null ? containerClass : styleClass + " " + containerClass;
        Iterator msgs = context.getMessages(targetClientId);
        writer.startElement("div", (UIComponent)uiMessage);
        writer.writeAttribute("id", (Object)uiMessage.getClientId(context), null);
        writer.writeAttribute("role", (Object)"alert", null);
        writer.writeAttribute("aria-atomic", (Object)"true", null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-display", (Object)display, null);
            writer.writeAttribute("data-target", (Object)targetClientId, null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(uiMessage.isRedisplay()), null);
        }
        if (msgs.hasNext()) {
            String severityName;
            FacesMessage msg = (FacesMessage)msgs.next();
            if (!this.shouldRender(uiMessage, msg, severityName = this.getSeverityName(msg))) {
                writer.writeAttribute("class", (Object)styleClass, null);
                writer.endElement("div");
                return;
            }
            FacesMessage.Severity severity = msg.getSeverity();
            String severityKey = null;
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                severityKey = "error";
            } else if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                severityKey = "info";
            } else if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                severityKey = "warn";
            } else if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
                severityKey = "fatal";
            }
            styleClass = styleClass + " ui-message-" + severityKey + " ui-widget ui-corner-all";
            if (iconOnly) {
                styleClass = styleClass + " ui-message-icon-only ui-helper-clearfix";
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.startElement("div", null);
            if (!"text".equals(display)) {
                this.encodeIcon(writer, severityKey, msg.getDetail(), iconOnly);
            }
            if (!iconOnly) {
                String summary = msg.getSummary();
                String detail = msg.getDetail();
                if (uiMessage.isSkipDetailIfEqualsSummary() && Objects.equals(summary, detail)) {
                    detail = "";
                }
                if (uiMessage.isShowSummary()) {
                    this.encodeText(context, uiMessage, summary, severityKey + "-summary");
                }
                if (uiMessage.isShowDetail()) {
                    this.encodeText(context, uiMessage, detail, severityKey + "-detail");
                }
            }
            writer.endElement("div");
            msg.rendered();
        } else {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.endElement("div");
    }

    protected void encodeText(FacesContext context, Message uiMessage, String text, String severity) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        writer.writeAttribute("id", (Object)(uiMessage.getClientId(context) + '_' + severity), null);
        if (uiMessage.isEscape()) {
            writer.writeText((Object)text, null);
        } else {
            writer.write(text);
        }
        writer.endElement("span");
    }

    protected void encodeIcon(ResponseWriter writer, String severity, String title, boolean iconOnly) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity + "-icon"), null);
        if (iconOnly) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Message uiMessage, UIComponent target) throws IOException {
        boolean tooltip = "tooltip".equals(uiMessage.getDisplay());
        if (tooltip || uiMessage.isShowDetail()) {
            String targetClientId = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
            WidgetBuilder wb = this.getWidgetBuilder(context);
            wb.init("Message", uiMessage).attr("target", targetClientId).attr("tooltip", tooltip, false).finish();
        }
    }
}

