/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.messages.Messages;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;

public class MessagesRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Messages uiMessages = (Messages)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiMessages.getClientId(context);
        boolean globalOnly = uiMessages.isGlobalOnly();
        String containerClass = uiMessages.isShowIcon() ? "ui-messages ui-widget" : "ui-messages ui-messages-noicon ui-widget";
        String style = uiMessages.getStyle();
        String styleClass = uiMessages.getStyleClass();
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        HashMap<String, List<FacesMessage>> messagesBySeverity = null;
        List<FacesMessage> messages = this.collectFacesMessages(uiMessages, context);
        if (messages != null && !messages.isEmpty()) {
            messagesBySeverity = new HashMap<String, List<FacesMessage>>(4);
            for (int i = 0; i < messages.size(); ++i) {
                FacesMessage message = messages.get(i);
                FacesMessage.Severity severity = message.getSeverity();
                if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "info");
                    continue;
                }
                if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "warn");
                    continue;
                }
                if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "error");
                    continue;
                }
                if (!severity.equals(FacesMessage.SEVERITY_FATAL)) continue;
                this.addMessage(uiMessages, message, messagesBySeverity, "fatal");
            }
        }
        writer.startElement("div", (UIComponent)uiMessages);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-global", (Object)String.valueOf(globalOnly), null);
            writer.writeAttribute("data-summary", (Object)uiMessages.isShowSummary(), null);
            writer.writeAttribute("data-detail", (Object)uiMessages.isShowDetail(), null);
            writer.writeAttribute("data-severity", (Object)this.getClientSideSeverity(uiMessages.getSeverity()), null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(uiMessages.isRedisplay()), null);
        }
        if (messagesBySeverity != null) {
            for (Map.Entry entry : messagesBySeverity.entrySet()) {
                this.encodeMessages(context, uiMessages, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        writer.endElement("div");
    }

    protected void addMessage(Messages uiMessages, FacesMessage message, Map<String, List<FacesMessage>> messagesBySeverity, String severity) {
        if (this.shouldRender(uiMessages, message, severity)) {
            List severityMessages = messagesBySeverity.computeIfAbsent(severity, k -> new ArrayList());
            severityMessages.add(message);
        }
    }

    protected void encodeMessages(FacesContext context, Messages uiMessages, String severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClassPrefix = "ui-messages-" + severity;
        boolean escape = uiMessages.isEscape();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(styleClassPrefix + " ui-corner-all"), null);
        if (uiMessages.isClosable()) {
            this.encodeCloseIcon(context, uiMessages);
        }
        if (uiMessages.isShowIcon()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-icon"), null);
            writer.endElement("span");
        }
        writer.startElement("ul", null);
        for (int i = 0; i < messages.size(); ++i) {
            FacesMessage message = messages.get(i);
            this.encodeMessage(writer, uiMessages, message, styleClassPrefix, escape);
            message.rendered();
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMessage(ResponseWriter writer, Messages uiMessages, FacesMessage message, String styleClassPrefix, boolean escape) throws IOException {
        String detail;
        writer.startElement("li", null);
        writer.writeAttribute("role", (Object)"alert", null);
        writer.writeAttribute("aria-atomic", (Object)"true", null);
        String summary = message.getSummary() != null ? message.getSummary() : "";
        String string = detail = message.getDetail() != null ? message.getDetail() : summary;
        if (uiMessages.isSkipDetailIfEqualsSummary() && Objects.equals(summary, detail)) {
            detail = "";
        }
        if (uiMessages.isShowSummary()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-summary"), null);
            if (escape) {
                writer.writeText((Object)summary, null);
            } else {
                writer.write(summary);
            }
            writer.endElement("span");
        }
        if (uiMessages.isShowDetail()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-detail"), null);
            if (escape) {
                writer.writeText((Object)detail, null);
            } else {
                writer.write(detail);
            }
            writer.endElement("span");
        }
        writer.endElement("li");
    }

    protected void encodeCloseIcon(FacesContext context, Messages uiMessages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-messages-close", null);
        writer.writeAttribute("onclick", (Object)"$(this).parent().slideUp();return false;", null);
        writer.writeAttribute("aria-label", (Object)MessageFactory.getMessage("primefaces.messages.aria.CLOSE", new Object[0]), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected List<FacesMessage> collectFacesMessages(Messages uiMessages, FacesContext context) {
        ArrayList<FacesMessage> messages;
        block15: {
            block14: {
                messages = null;
                String _for = uiMessages.getFor();
                if (this.isValueBlank(_for)) break block14;
                String forType = uiMessages.getForType();
                if (forType == null || "key".equals(forType)) {
                    String[] keys;
                    for (String key : keys = SearchExpressionFacade.split(context, _for, SearchExpressionFacade.EXPRESSION_SEPARATORS)) {
                        Iterator messagesIterator = context.getMessages(key);
                        while (messagesIterator.hasNext()) {
                            if (messages == null) {
                                messages = new ArrayList(5);
                            }
                            messages.add((FacesMessage)messagesIterator.next());
                        }
                    }
                }
                if (forType != null && !"expression".equals(forType)) break block15;
                List<UIComponent> forComponents = SearchExpressionFacade.resolveComponents(context, (UIComponent)uiMessages, _for, SearchExpressionUtils.SET_IGNORE_NO_RESULT);
                for (int i = 0; i < forComponents.size(); ++i) {
                    UIComponent forComponent = forComponents.get(i);
                    String forComponentClientId = forComponent.getClientId(context);
                    if (_for.equals(forComponentClientId)) continue;
                    Iterator messagesIterator = context.getMessages(forComponentClientId);
                    while (messagesIterator.hasNext()) {
                        FacesMessage next = (FacesMessage)messagesIterator.next();
                        if (messages == null) {
                            messages = new ArrayList(5);
                        }
                        if (messages.contains(next)) continue;
                        messages.add(next);
                    }
                }
                break block15;
            }
            if (uiMessages.isGlobalOnly()) {
                Iterator messagesIterator = context.getMessages(null);
                while (messagesIterator.hasNext()) {
                    if (messages == null) {
                        messages = new ArrayList<FacesMessage>(5);
                    }
                    messages.add((FacesMessage)messagesIterator.next());
                }
            } else {
                Object[] ignores = uiMessages.getForIgnores() == null ? null : SearchExpressionFacade.split(context, uiMessages.getForIgnores(), SearchExpressionFacade.EXPRESSION_SEPARATORS);
                Iterator keyIterator = context.getClientIdsWithMessages();
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    if (ignores != null && LangUtils.contains(ignores, key)) continue;
                    Iterator messagesIterator = context.getMessages(key);
                    while (messagesIterator.hasNext()) {
                        if (messages == null) {
                            messages = new ArrayList(5);
                        }
                        messages.add((FacesMessage)messagesIterator.next());
                    }
                }
            }
        }
        return messages;
    }
}

