/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.radarchart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.radarchart.RadarChart;
import org.primefaces.model.charts.radar.RadarChartOptions;
import org.primefaces.util.WidgetBuilder;

public class RadarChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RadarChart chart = (RadarChart)component;
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        this.encodeMarkup(context, clientId, style, styleClass);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, RadarChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("RadarChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        RadarChartOptions radarOptions = (RadarChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeScales(context, type, radarOptions.getScales(), false);
        this.encodeElements(context, radarOptions.getElements(), radarOptions.getScales() != null);
        this.encodeTitle(context, radarOptions.getTitle(), radarOptions.getScales() != null || radarOptions.getElements() != null);
        this.encodeTooltip(context, radarOptions.getTooltip(), radarOptions.getScales() != null || radarOptions.getElements() != null || radarOptions.getTitle() != null);
        this.encodeLegend(context, radarOptions.getLegend(), radarOptions.getScales() != null || radarOptions.getElements() != null || radarOptions.getTitle() != null || radarOptions.getTooltip() != null);
        this.encodeAnimation(context, radarOptions.getAnimation(), radarOptions.getScales() != null || radarOptions.getElements() != null || radarOptions.getTitle() != null || radarOptions.getTooltip() != null);
        writer.write("}");
    }
}

