/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.ajax;

import java.util.ArrayList;
import java.util.Collection;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import org.primefaces.behavior.ajax.AjaxBehavior;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.AjaxRequestBuilder;

public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (!ajaxBehavior.isDisabled()) {
            AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)behavior);
            PhaseId phaseId = this.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
            event.setPhaseId(phaseId);
            component.queueEvent((FacesEvent)event);
        }
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        UIComponent component = behaviorContext.getComponent();
        ClientBehaviorRenderingMode renderingMode = ClientBehaviorRenderingMode.OBSTRUSIVE;
        Collection behaviorParameters = behaviorContext.getParameters();
        if (behaviorParameters != null && !behaviorParameters.isEmpty()) {
            if (behaviorParameters instanceof ArrayList) {
                for (int i = 0; i < behaviorParameters.size(); ++i) {
                    ClientBehaviorContext.Parameter behaviorParameter = (ClientBehaviorContext.Parameter)((ArrayList)behaviorParameters).get(i);
                    if (!(behaviorParameter.getValue() instanceof ClientBehaviorRenderingMode)) continue;
                    renderingMode = (ClientBehaviorRenderingMode)((Object)behaviorParameter.getValue());
                    break;
                }
            } else {
                for (ClientBehaviorContext.Parameter behaviorParameter : behaviorParameters) {
                    if (!(behaviorParameter.getValue() instanceof ClientBehaviorRenderingMode)) continue;
                    renderingMode = (ClientBehaviorRenderingMode)((Object)behaviorParameter.getValue());
                    break;
                }
            }
        }
        String source = behaviorContext.getSourceId();
        String process = ajaxBehavior.getProcess();
        if (process == null) {
            process = "@this";
        }
        AjaxRequestBuilder builder = PrimeRequestContext.getCurrentInstance().getAjaxRequestBuilder();
        String request = builder.init().source(source).event(behaviorContext.getEventName()).form(ajaxBehavior, component).process(component, process, ajaxBehavior.isIgnoreComponentNotFound()).update(component, ajaxBehavior.getUpdate(), ajaxBehavior.isIgnoreComponentNotFound()).async(ajaxBehavior.isAsync()).global(ajaxBehavior.isGlobal()).delay(ajaxBehavior.getDelay()).timeout(ajaxBehavior.getTimeout()).partialSubmit(ajaxBehavior.isPartialSubmit(), ajaxBehavior.isPartialSubmitSet(), ajaxBehavior.getPartialSubmitFilter()).resetValues(ajaxBehavior.isResetValues(), ajaxBehavior.isResetValuesSet()).ignoreAutoUpdate(ajaxBehavior.isIgnoreAutoUpdate()).skipChildren(ajaxBehavior.isSkipChildren()).onstart(ajaxBehavior.getOnstart()).onerror(ajaxBehavior.getOnerror()).onsuccess(ajaxBehavior.getOnsuccess()).oncomplete(ajaxBehavior.getOncomplete()).params(component).buildBehavior(renderingMode);
        return request;
    }

    private boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)component).isImmediate();
        }
        return immediate;
    }
}

