/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.Serializable;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.TouchAware;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;

public abstract class UICalendar
extends AbstractPrimeHtmlInputText
implements InputHolder,
TouchAware {
    public static final String CONTAINER_CLASS = "ui-calendar";
    public static final String INPUT_STYLE_CLASS = "ui-inputfield ui-widget ui-state-default ui-corner-all";
    public static final String DATE_OUT_OF_RANGE_MESSAGE_ID = "primefaces.calendar.OUT_OF_RANGE";
    public static final String DATE_MIN_DATE_ID = "primefaces.calendar.MIN_DATE";
    public static final String DATE_MAX_DATE_ID = "primefaces.calendar.MAX_DATE";
    public static final String DATE_INVALID_MESSAGE_ID = "primefaces.calendar.INVALID";
    public static final String DATE_INVALID_RANGE_MESSAGE_ID = "primefaces.calendar.DATE_INVALID_RANGE_MESSAGE_ID";
    protected static final List<String> UNOBSTRUSIVE_EVENT_NAMES = LangUtils.unmodifiableList("dateSelect", "viewChange", "close");
    protected static final Collection<String> CALENDAR_EVENT_NAMES = LangUtils.concat(AbstractPrimeHtmlInputText.EVENT_NAMES, UNOBSTRUSIVE_EVENT_NAMES);
    protected String timeOnlyPattern;
    private boolean conversionFailed;

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), timeZone);
    }

    public String getPattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pattern), null);
    }

    public void setPattern(String pattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pattern), (Object)pattern);
    }

    public Object getMindate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mindate), null);
    }

    public void setMindate(Object mindate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mindate), mindate);
    }

    public Object getMaxdate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxdate), null);
    }

    public void setMaxdate(Object maxdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxdate), maxdate);
    }

    public boolean isTimeOnly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeOnly), (Object)false);
    }

    public Boolean isTimeOnlyWithoutDefault() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeOnly));
    }

    public void setTimeOnly(boolean timeOnly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeOnly), (Object)timeOnly);
    }

    public boolean isReadonlyInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyInput), (Object)false);
    }

    public void setReadonlyInput(boolean readonlyInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyInput), (Object)readonlyInput);
    }

    public String getInputStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyle), null);
    }

    public void setInputStyle(String inputStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyle), (Object)inputStyle);
    }

    public String getInputStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputStyleClass), null);
    }

    public void setInputStyleClass(String inputStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.inputStyleClass), (Object)inputStyleClass);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"text");
    }

    public void setType(String type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)type);
    }

    public String getSelectionMode() {
        return null;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return LocaleUtils.resolveLocale(facesContext, this.getLocale(), this.getClientId(facesContext));
    }

    public boolean hasTime() {
        String pattern = this.getPattern();
        return pattern != null && (pattern.contains("HH") || pattern.contains("mm") || pattern.contains("ss"));
    }

    public String calculatePattern() {
        String pattern = this.getPattern();
        if (pattern == null) {
            return this.calculateLocalizedPattern();
        }
        return pattern;
    }

    public String calculateTimeOnlyPattern() {
        if (this.timeOnlyPattern == null) {
            String localePattern = this.calculateLocalizedPattern();
            String userTimePattern = this.getPattern();
            this.timeOnlyPattern = localePattern + " " + userTimePattern;
        }
        return this.timeOnlyPattern;
    }

    public String calculateLocalizedPattern() {
        Locale locale = this.calculateLocale(this.getFacesContext());
        String localePattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, IsoChronology.INSTANCE, locale);
        if (LangUtils.countMatches(localePattern, 'y') == 2) {
            localePattern = localePattern.replace("yy", "yyyy");
        }
        return localePattern;
    }

    public abstract String calculateWidgetPattern();

    public String convertPattern(String patternTemplate) {
        char[] chars = patternTemplate.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != 'm' && c != 'M') continue;
            if (Character.isUpperCase(c)) {
                chars[i] = Character.toLowerCase(c);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            chars[i] = Character.toUpperCase(c);
        }
        String pattern = new String(chars);
        int countY = LangUtils.countMatches(pattern, 'y');
        int countM = LangUtils.countMatches(pattern, 'm');
        int countD = LangUtils.countMatches(pattern, 'd');
        if (countD == 1) {
            pattern = pattern.replace("d", "dd");
        }
        if (countM == 1) {
            pattern = pattern.replace("m", "mm");
        }
        if (countY == 1) {
            pattern = pattern.replace("y", "yy");
        }
        return pattern;
    }

    public boolean isConversionFailed() {
        return this.conversionFailed;
    }

    public void setConversionFailed(boolean value) {
        this.conversionFailed = value;
    }

    @Override
    public String getInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    @Override
    public String getValidatableInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    @Override
    public String getLabelledBy() {
        return (String)this.getStateHelper().get((Serializable)((Object)"labelledby"));
    }

    @Override
    public void setLabelledBy(String labelledBy) {
        this.getStateHelper().put((Serializable)((Object)"labelledby"), (Object)labelledBy);
    }

    public String getRangeSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rangeSeparator), (Object)"-");
    }

    public void setRangeSeparator(String _rangeSeparator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rangeSeparator), (Object)_rangeSeparator);
    }

    public String getResolverStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resolverStyle), (Object)ResolverStyle.SMART.name());
    }

    public void setResolverStyle(String resolverStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resolverStyle), (Object)resolverStyle);
    }

    @Override
    public boolean isTouchable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.touchable), (Object)true);
    }

    @Override
    public void setTouchable(boolean touchable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.touchable), (Object)touchable);
    }

    public String getMask() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mask), (Object)"false");
    }

    public void setMask(String mask) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mask), (Object)mask);
    }

    public String getMaskSlotChar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maskSlotChar), (Object)"_");
    }

    public void setMaskSlotChar(String maskSlotChar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maskSlotChar), (Object)maskSlotChar);
    }

    public boolean isMaskAutoClear() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maskAutoClear), (Object)true);
    }

    public void setMaskAutoClear(boolean maskAutoClear) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maskAutoClear), (Object)maskAutoClear);
    }

    protected void createFacesMessageFromValidationResult(FacesContext context, ValidationResult validationResult) {
        FacesMessage msg = null;
        String validatorMessage = this.getValidatorMessage();
        Object[] params = new Object[]{ComponentUtils.getLabel(context, (UIComponent)this), CalendarUtils.getValueAsString(context, this, this.getMindate()), CalendarUtils.getValueAsString(context, this, this.getMaxdate())};
        if (validatorMessage != null) {
            msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
        } else {
            switch (validationResult) {
                case OK: {
                    break;
                }
                case INVALID_DISABLED_DATE: {
                    msg = MessageFactory.getFacesMessage(DATE_INVALID_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params);
                    break;
                }
                case INVALID_RANGE_DATES_SEQUENTIAL: {
                    msg = MessageFactory.getFacesMessage(DATE_INVALID_RANGE_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params);
                    break;
                }
                case INVALID_MIN_DATE: {
                    msg = MessageFactory.getFacesMessage(DATE_MIN_DATE_ID, FacesMessage.SEVERITY_ERROR, params);
                    break;
                }
                case INVALID_MAX_DATE: {
                    msg = MessageFactory.getFacesMessage(DATE_MAX_DATE_ID, FacesMessage.SEVERITY_ERROR, params);
                    break;
                }
                case INVALID_OUT_OF_RANGE: {
                    msg = MessageFactory.getFacesMessage(DATE_OUT_OF_RANGE_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params);
                }
            }
        }
        context.addMessage(this.getClientId(context), msg);
    }

    public Class<?> getTypeFromValueByValueExpression(FacesContext context) {
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            return ve.getType(context.getELContext());
        }
        return null;
    }

    public void validateMinMax(FacesContext context) {
        Comparable minDate = (Comparable)this.getMindate();
        Comparable maxDate = (Comparable)this.getMaxdate();
        if (minDate != null && maxDate != null && maxDate.compareTo(minDate) < 0) {
            String id = this.getClientId(context);
            String component = this.getClass().getSimpleName();
            throw new FacesException(component + " : \"" + id + "\" minimum date must be less than maximum date.");
        }
    }

    public static enum ValidationResult {
        OK,
        INVALID_DISABLED_DATE,
        INVALID_RANGE_DATES_SEQUENTIAL,
        INVALID_MIN_DATE,
        INVALID_MAX_DATE,
        INVALID_OUT_OF_RANGE;

    }

    public static enum PropertyKeys {
        locale,
        timeZone,
        pattern,
        mindate,
        maxdate,
        timeOnly,
        readonlyInput,
        inputStyle,
        inputStyleClass,
        type,
        rangeSeparator,
        resolverStyle,
        touchable,
        mask,
        maskSlotChar,
        maskAutoClear;

    }
}

