/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.ColumnAware;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.MultiViewStateAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITableState;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public interface UITable<T extends UITableState>
extends ColumnAware,
MultiViewStateAware<T> {
    public static final Pattern OLD_SYNTAX_COLUMN_PROPERTY_REGEX = Pattern.compile("^#\\{\\w+\\[(.+)]}$");

    public static String resolveStaticField(ValueExpression expression) {
        String expressionString;
        if (expression != null && (expressionString = expression.getExpressionString()).startsWith("#{")) {
            expressionString = expressionString.substring(2, expressionString.indexOf(125));
            return expressionString.substring(expressionString.indexOf(46) + 1);
        }
        return null;
    }

    public static String resolveDynamicField(FacesContext context, ValueExpression exprVE) {
        if (exprVE == null) {
            return null;
        }
        ELContext elContext = context.getELContext();
        String exprStr = exprVE.getExpressionString();
        Matcher matcher = OLD_SYNTAX_COLUMN_PROPERTY_REGEX.matcher(exprStr);
        if (matcher.find()) {
            exprStr = matcher.group(1);
            exprVE = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + exprStr + "}", String.class);
        }
        return (String)exprVE.getValue(elContext);
    }

    public static ValueExpression createValueExprFromVarField(FacesContext context, String var, String field) {
        if (LangUtils.isValueBlank(var) || LangUtils.isValueBlank(field)) {
            throw new FacesException("Table 'var' and Column 'field' attributes must be non null.");
        }
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), "#{" + var + "." + field + "}", Object.class);
    }

    public String getVar();

    public String getClientId(FacesContext var1);

    default public Map<String, FilterMeta> initFilterBy(FacesContext context) {
        boolean invalidate = !this.isFilterByAsMapDefined();
        HashMap<String, FilterMeta> filterBy = invalidate ? new HashMap() : this.getFilterByAsMap();
        AtomicBoolean filtered = invalidate ? new AtomicBoolean() : new AtomicBoolean(this.isDefaultFilter());
        this.forEachColumn(c -> {
            FilterMeta f = (FilterMeta)filterBy.get(c.getColumnKey());
            if (f != null && !invalidate) {
                f.setColumn((UIColumn)c);
            } else {
                f = FilterMeta.of(context, this.getVar(), c);
                if (f != null) {
                    filterBy.put(f.getColumnKey(), f);
                    filtered.set(filtered.get() || f.isActive());
                }
            }
            return true;
        });
        Object userfilterBy = this.getFilterBy();
        if (userfilterBy != null) {
            this.updateFilterByWithUserFilterBy(context, filterBy, userfilterBy, filtered);
        }
        this.updateFilterByWithGlobalFilter(context, filterBy, filtered);
        this.setDefaultFilter(filtered.get());
        this.setFilterByAsMap(filterBy);
        return filterBy;
    }

    default public void updateFilterByWithMVS(FacesContext context, Map<String, FilterMeta> tsFilterBy) {
        boolean defaultFilter = this.isDefaultFilter();
        for (Map.Entry<String, FilterMeta> entry : tsFilterBy.entrySet()) {
            FilterMeta intlFilterBy = this.getFilterByAsMap().get(entry.getKey());
            if (intlFilterBy == null) continue;
            FilterMeta tsFilterMeta = entry.getValue();
            intlFilterBy.setFilterValue(tsFilterMeta.getFilterValue());
            defaultFilter |= intlFilterBy.isActive();
        }
        this.setDefaultFilter(defaultFilter);
    }

    default public void updateFilterByWithUserFilterBy(FacesContext context, Map<String, FilterMeta> intlFilterBy, Object usrFilterBy, AtomicBoolean filtered) {
        Collection<FilterMeta> filterByTmp;
        if (usrFilterBy instanceof FilterMeta) {
            filterByTmp = Collections.singletonList((FilterMeta)usrFilterBy);
        } else {
            if (!(usrFilterBy instanceof Collection)) {
                throw new FacesException("filterBy expects a single or a collection of FilterMeta");
            }
            filterByTmp = (Collection)usrFilterBy;
        }
        for (FilterMeta userFM : filterByTmp) {
            FilterMeta intlFM = intlFilterBy.values().stream().filter(o -> o.getField().equals(userFM.getField())).findAny().orElseThrow(() -> new FacesException("No column with field '" + userFM.getField() + "' has been found"));
            ValueExpression filterByVE = userFM.getFilterBy();
            if (filterByVE == null) {
                filterByVE = UITable.createValueExprFromVarField(context, this.getVar(), userFM.getField());
            }
            intlFM.setFilterValue(userFM.getFilterValue());
            intlFM.setFilterBy(filterByVE);
            intlFM.setConstraint(userFM.getConstraint());
            intlFM.setMatchMode(userFM.getMatchMode());
            filtered.set(filtered.get() || userFM.isActive());
        }
    }

    default public void updateFilterByWithGlobalFilter(FacesContext context, Map<String, FilterMeta> filterBy, AtomicBoolean filtered) {
        String globalFilterDefaultValue = this.getGlobalFilter();
        Set<SearchExpressionHint> hint = LangUtils.isValueBlank(globalFilterDefaultValue) ? SearchExpressionUtils.SET_IGNORE_NO_RESULT : SearchExpressionUtils.SET_NONE;
        UIComponent globalFilterComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)this, "globalFilter", hint);
        if (globalFilterComponent != null) {
            if (globalFilterComponent instanceof ValueHolder) {
                ((ValueHolder)globalFilterComponent).setValue((Object)globalFilterDefaultValue);
            }
            FilterMeta globalFilterBy = FilterMeta.of(globalFilterDefaultValue, this.getGlobalFilterFunction());
            filterBy.put(globalFilterBy.getColumnKey(), globalFilterBy);
            filtered.set(filtered.get() || globalFilterBy.isActive());
        }
    }

    default public boolean isColumnFilterable(UIColumn column) {
        Map<String, FilterMeta> filterBy = this.getFilterByAsMap();
        return filterBy.containsKey(column.getColumnKey());
    }

    default public void updateFilterByValuesWithFilterRequest(FacesContext context, Map<String, FilterMeta> filterBy) {
        Map params = context.getExternalContext().getRequestParameterMap();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        FilterMeta globalFilter = filterBy.get("globalFilter");
        if (globalFilter != null) {
            globalFilter.setFilterValue(params.get(((UIComponent)this).getClientId(context) + separator + "globalFilter"));
        }
        this.forEachColumn(column -> {
            Object filterValue;
            boolean hasCustomFilter;
            FilterMeta filterMeta = (FilterMeta)filterBy.get(column.getColumnKey());
            if (filterMeta == null || filterMeta.isGlobalFilter()) {
                return true;
            }
            UIComponent filterFacet = column.getFacet("filter");
            boolean bl = hasCustomFilter = filterFacet != null;
            if (column instanceof DynamicColumn) {
                if (hasCustomFilter) {
                    ((DynamicColumn)column).applyModel();
                    hasCustomFilter = ComponentUtils.shouldRenderFacet(filterFacet);
                } else {
                    ((DynamicColumn)column).applyStatelessModel();
                }
            }
            if (hasCustomFilter) {
                filterValue = ((ValueHolder)filterFacet).getLocalValue();
            } else {
                String valueHolderClientId = column instanceof DynamicColumn ? column.getContainerClientId(context) + separator + "filter" : column.getClientId(context) + separator + "filter";
                filterValue = params.get(valueHolderClientId);
            }
            if (filterValue != null && (filterValue instanceof String && LangUtils.isValueBlank((String)filterValue) || filterValue.getClass().isArray() && Array.getLength(filterValue) == 0)) {
                filterValue = null;
            }
            filterMeta.setFilterValue(filterValue);
            return true;
        });
    }

    default public Object getFilterValue(UIColumn column) {
        return this.getFilterByAsMap().get(column.getColumnKey()).getFilterValue();
    }

    public boolean isDefaultFilter();

    public void setDefaultFilter(boolean var1);

    public Object getFilterBy();

    public void setFilterBy(Object var1);

    public boolean isFilterByAsMapDefined();

    public Map<String, FilterMeta> getFilterByAsMap();

    public void setFilterByAsMap(Map<String, FilterMeta> var1);

    default public Map<String, FilterMeta> getActiveFilterMeta() {
        return this.getFilterByAsMap().values().stream().filter(FilterMeta::isActive).collect(Collectors.toMap(FilterMeta::getField, Function.identity()));
    }

    public String getGlobalFilter();

    public void setGlobalFilter(String var1);

    public MethodExpression getGlobalFilterFunction();

    public void setGlobalFilterFunction(MethodExpression var1);

    default public Map<String, SortMeta> initSortBy(FacesContext context) {
        HashMap<String, SortMeta> sortMeta = new HashMap<String, SortMeta>();
        AtomicBoolean sorted = new AtomicBoolean();
        HeaderRow headerRow = this.getHeaderRow();
        if (headerRow != null) {
            SortMeta s = SortMeta.of(context, this.getVar(), headerRow);
            sortMeta.put(s.getColumnKey(), s);
            sorted.set(true);
        }
        this.forEachColumn(c -> {
            SortMeta s = SortMeta.of(context, this.getVar(), c);
            if (s != null) {
                sorted.set(sorted.get() || s.isActive());
                sortMeta.put(s.getColumnKey(), s);
            }
            return true;
        });
        Object userSortBy = this.getSortBy();
        if (userSortBy != null) {
            this.updateSortByWithUserSortBy(context, sortMeta, userSortBy, sorted);
        }
        this.setDefaultSort(sorted.get());
        return sortMeta;
    }

    default public void updateSortByWithMVS(Map<String, SortMeta> tsSortBy) {
        boolean defaultSort = this.isDefaultSort();
        for (Map.Entry<String, SortMeta> entry : tsSortBy.entrySet()) {
            SortMeta intlSortBy = this.getSortByAsMap().get(entry.getKey());
            if (intlSortBy == null) continue;
            SortMeta tsSortMeta = entry.getValue();
            intlSortBy.setPriority(tsSortMeta.getPriority());
            intlSortBy.setOrder(tsSortMeta.getOrder());
            defaultSort |= intlSortBy.isActive();
        }
        this.setDefaultSort(defaultSort);
    }

    default public void updateSortByWithUserSortBy(FacesContext context, Map<String, SortMeta> intlSortBy, Object usrSortBy, AtomicBoolean sorted) {
        Collection<SortMeta> sortBy;
        if (usrSortBy instanceof SortMeta) {
            sortBy = Collections.singletonList((SortMeta)usrSortBy);
        } else {
            if (!(usrSortBy instanceof Collection)) {
                throw new FacesException("sortBy expects a single or a collection of SortMeta");
            }
            sortBy = (Collection)usrSortBy;
        }
        for (SortMeta userSM : sortBy) {
            SortMeta intlSM = intlSortBy.values().stream().filter(o -> o.getField().equals(userSM.getField())).findAny().orElseThrow(() -> new FacesException("No column with field '" + userSM.getField() + "' has been found"));
            ValueExpression sortByVE = userSM.getSortBy();
            if (sortByVE == null) {
                sortByVE = UITable.createValueExprFromVarField(context, this.getVar(), userSM.getField());
            }
            intlSM.setPriority(userSM.getPriority());
            intlSM.setOrder(userSM.getOrder());
            intlSM.setSortBy(sortByVE);
            intlSM.setFunction(userSM.getFunction());
            sorted.set(sorted.get() || userSM.isActive());
        }
    }

    default public SortMeta getHighestPriorityActiveSortMeta() {
        return this.getSortByAsMap().values().stream().filter(SortMeta::isActive).min(Comparator.comparingInt(SortMeta::getPriority)).orElse(null);
    }

    default public Map<String, SortMeta> getActiveSortMeta() {
        return this.getSortByAsMap().values().stream().filter(SortMeta::isActive).sorted().collect(Collectors.toMap(SortMeta::getField, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
    }

    default public boolean isSortingCurrentlyActive() {
        return this.getSortByAsMap().values().stream().anyMatch(SortMeta::isActive);
    }

    default public boolean isColumnSortable(FacesContext context, UIColumn column) {
        Map<String, SortMeta> sortBy = this.getSortByAsMap();
        if (sortBy.containsKey(column.getColumnKey())) {
            return true;
        }
        SortMeta s = SortMeta.of(context, this.getVar(), column);
        if (s == null) {
            return false;
        }
        sortBy.put(s.getColumnKey(), s);
        this.setSortByAsMap(sortBy);
        return true;
    }

    default public String getSortMetaAsString() {
        return this.getActiveSortMeta().values().stream().map(SortMeta::getColumnKey).collect(Collectors.joining("','", "['", "']"));
    }

    default public boolean isSortingEnabled() {
        return !this.getSortByAsMap().isEmpty();
    }

    default public HeaderRow getHeaderRow() {
        return null;
    }

    public Map<String, SortMeta> getSortByAsMap();

    public void setSortByAsMap(Map<String, SortMeta> var1);

    default public boolean isFilteringEnabled() {
        return !this.getFilterByAsMap().isEmpty();
    }

    public Object getSortBy();

    public void setSortBy(Object var1);

    public boolean isDefaultSort();

    public void setDefaultSort(boolean var1);

    default public void decodeColumnTogglerState(FacesContext context) {
        String columnTogglerStateParam = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_columnTogglerState");
        if (columnTogglerStateParam == null) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setVisible(null));
        if (!LangUtils.isValueBlank(columnTogglerStateParam)) {
            String[] columnStates;
            for (String columnState : columnStates = columnTogglerStateParam.split(",")) {
                if (LangUtils.isValueBlank(columnState)) continue;
                int seperatorIndex = columnState.lastIndexOf(95);
                String columnKey = columnState.substring(0, seperatorIndex);
                boolean visible = Boolean.parseBoolean(columnState.substring(seperatorIndex + 1));
                ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
                meta.setVisible(visible);
            }
        }
        if (this.isMultiViewState()) {
            UITableState state = (UITableState)this.getMultiViewState(true);
            state.setColumnMeta(columMeta);
        }
    }

    default public void decodeColumnResizeState(FacesContext context) {
        String columnResizeStateParam = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_resizableColumnState");
        if (columnResizeStateParam == null) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setWidth(null));
        String tableWidth = null;
        if (!LangUtils.isValueBlank(columnResizeStateParam)) {
            String[] columnStates;
            for (String columnState : columnStates = columnResizeStateParam.split(",")) {
                if (LangUtils.isValueBlank(columnState)) continue;
                if ((this.getClientId(context) + "_tableWidthState").equals(columnState)) {
                    tableWidth = columnState;
                    this.setWidth(tableWidth);
                    continue;
                }
                int seperatorIndex = columnState.lastIndexOf(95);
                String columnKey = columnState.substring(0, seperatorIndex);
                String width = columnState.substring(seperatorIndex + 1);
                ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
                meta.setWidth(width);
            }
        }
        if (this.isMultiViewState()) {
            UITableState state = (UITableState)this.getMultiViewState(true);
            state.setWidth(tableWidth);
            state.setColumnMeta(columMeta);
        }
    }

    public String getWidth();

    public void setWidth(String var1);

    default public void decodeColumnDisplayOrderState(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String columnOrderParam = (String)params.get(this.getClientId(context) + "_columnOrder");
        if (LangUtils.isValueBlank(columnOrderParam)) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setDisplayPriority(0));
        String[] columnKeys = columnOrderParam.split(",");
        for (int i = 0; i < columnKeys.length; ++i) {
            String columnKey = columnKeys[i];
            if (LangUtils.isValueBlank(columnKey)) continue;
            ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
            meta.setDisplayPriority(i);
        }
        if (this.isMultiViewState()) {
            UITableState ts = (UITableState)this.getMultiViewState(true);
            ts.setColumnMeta(columMeta);
        }
    }

    default public String getColumnsWidthForClientSide() {
        return this.getColumnMeta().entrySet().stream().map(e -> (String)e.getKey() + '_' + ((ColumnMeta)e.getValue()).getWidth()).collect(Collectors.joining(","));
    }

    default public String getConvertedFieldValue(FacesContext context, UIColumn column) {
        Object value = UITable.createValueExprFromVarField(context, this.getVar(), column.getField()).getValue(context.getELContext());
        Object component = column instanceof DynamicColumn ? ((DynamicColumn)column).getColumns() : (UIComponent)column;
        return ComponentUtils.getConvertedAsString(context, component, value);
    }

    default public boolean isFilteringCurrentlyActive() {
        return this.getFilterByAsMap().values().stream().anyMatch(FilterMeta::isActive);
    }
}

