/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.primefaces.component.api.SavedState;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.WrapperEvent;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.SharedStringBuilder;

public abstract class UITree
extends UIComponentBase
implements NamingContainer {
    public static final String SEPARATOR = "_";
    public static final String REQUIRED_MESSAGE_ID = "primefaces.tree.REQUIRED";
    public static final String CHECKBOX_CLASS = "ui-selection";
    public static final String ROOT_ROW_KEY = "root";
    private static final String SB_GET_CONTAINER_CLIENT_ID = UITree.class.getName() + "#getContainerClientId";
    private static final String SB_GET_SELECTED_ROW_KEYS_AS_STRING = UITree.class.getName() + "#getSelectedRowKeysAsString";
    private String rowKey;
    private TreeNode rowNode;
    private boolean rtl;
    private List<TreeNode> preselection;
    private Boolean isNested;

    public String getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(String rowKey) {
        this.setRowKey(this.getValue(), rowKey);
    }

    public void setRowKey(TreeNode root, String rowKey) {
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        this.saveDescendantState();
        String nodeVar = this.getNodeVar();
        this.rowKey = rowKey;
        if (rowKey == null) {
            requestMap.remove(this.getVar());
            this.rowNode = null;
            if (nodeVar != null) {
                requestMap.remove(nodeVar);
            }
        } else {
            this.rowNode = this.findTreeNode(root, rowKey);
            if (this.rowNode != null) {
                requestMap.put(this.getVar(), this.rowNode.getData());
                if (nodeVar != null) {
                    requestMap.put(nodeVar, this.rowNode);
                }
            } else {
                requestMap.remove(this.getVar());
                if (nodeVar != null) {
                    requestMap.remove(nodeVar);
                }
            }
        }
        this.restoreDescendantState();
    }

    private void addToPreselection(TreeNode node) {
        if (this.preselection == null) {
            this.preselection = new ArrayList<TreeNode>();
        }
        this.preselection.add(node);
    }

    public TreeNode getRowNode() {
        return this.rowNode;
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.var), null);
    }

    public void setVar(String _var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)_var);
    }

    public String getNodeVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nodeVar), null);
    }

    public void setNodeVar(String _nodeVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nodeVar), (Object)_nodeVar);
    }

    public TreeNode getValue() {
        return (TreeNode)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(TreeNode _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)_value);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), (Object)false);
    }

    public void setRequired(boolean _required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), (Object)_required);
    }

    public String getRequiredMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.requiredMessage), null);
    }

    public void setRequiredMessage(String _requiredMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.requiredMessage), (Object)_requiredMessage);
    }

    public boolean isSkipChildren() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.skipChildren), (Object)false);
    }

    public void setSkipChildren(boolean _skipChildren) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.skipChildren), (Object)_skipChildren);
    }

    public boolean isShowUnselectableCheckbox() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showUnselectableCheckbox), (Object)false);
    }

    public void setShowUnselectableCheckbox(boolean _showUnselectableCheckbox) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showUnselectableCheckbox), (Object)_showUnselectableCheckbox);
    }

    public Object getLocalSelectedNodes() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    public boolean isPropagateSelectionDown() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.propagateSelectionDown), (Object)true);
    }

    public void setPropagateSelectionDown(boolean _propagateSelectionDown) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.propagateSelectionDown), (Object)_propagateSelectionDown);
    }

    public boolean isPropagateSelectionUp() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.propagateSelectionUp), (Object)true);
    }

    public void setPropagateSelectionUp(boolean _propagateSelectionUp) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.propagateSelectionUp), (Object)_propagateSelectionUp);
    }

    protected TreeNode findTreeNode(TreeNode searchRoot, String rowKey) {
        if (rowKey == null || searchRoot == null) {
            return null;
        }
        if (rowKey.equals(ROOT_ROW_KEY)) {
            return this.getValue();
        }
        String[] paths = rowKey.split(SEPARATOR);
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        if (childIndex >= searchRoot.getChildCount()) {
            return null;
        }
        searchRoot = searchRoot.getChildren().get(childIndex);
        if (paths.length == 1) {
            return searchRoot;
        }
        String relativeRowKey = rowKey.substring(rowKey.indexOf(SEPARATOR) + 1);
        return this.findTreeNode(searchRoot, relativeRowKey);
    }

    public void buildRowKeys(TreeNode node) {
        int childCount;
        if ((node.isExpanded() || node.getParent() == null || node.getParent().isExpanded()) && (childCount = node.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                TreeNode childNode = node.getChildren().get(i);
                if (childNode.isSelected()) {
                    this.addToPreselection(childNode);
                }
                String childRowKey = node.getParent() == null ? String.valueOf(i) : node.getRowKey() + SEPARATOR + i;
                childNode.setRowKey(childRowKey);
                this.buildRowKeys(childNode);
            }
        }
    }

    public void populateRowKeys(TreeNode node, List<String> keys) {
        int childCount;
        if (node == null) {
            return;
        }
        if ((node.isExpanded() || node.getParent() == null || node.getParent().isExpanded()) && (childCount = node.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                TreeNode childNode = node.getChildren().get(i);
                keys.add(childNode.getRowKey());
                this.populateRowKeys(childNode, keys);
            }
        }
    }

    public void updateRowKeys(TreeNode node) {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                TreeNode childNode = node.getChildren().get(i);
                String childRowKey = node.getParent() == null ? String.valueOf(i) : node.getRowKey() + SEPARATOR + i;
                childNode.setRowKey(childRowKey);
                this.updateRowKeys(childNode);
            }
        }
    }

    public void initPreselection() {
        ValueExpression ve = this.getValueExpression(PropertyKeys.selection.toString());
        if (ve != null) {
            if (this.preselection != null) {
                String selectionMode = this.getSelectionMode();
                if (selectionMode != null) {
                    if ("single".equals(selectionMode)) {
                        if (!this.preselection.isEmpty()) {
                            ve.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)this.preselection.get(0));
                        }
                    } else {
                        ve.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)this.preselection.toArray(new TreeNode[0]));
                    }
                    this.preselection = null;
                }
            } else {
                ve.setValue(FacesContext.getCurrentInstance().getELContext(), null);
            }
        }
    }

    private void updateSelectedNodes(TreeNode node) {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                TreeNode childNode = node.getChildren().get(i);
                if (childNode.isSelected()) {
                    this.addToPreselection(childNode);
                }
                this.updateSelectedNodes(childNode);
            }
        }
    }

    public void refreshSelectedNodeKeys() {
        TreeNode root = this.getValue();
        this.preselection = null;
        this.updateSelectedNodes(root);
        this.initPreselection();
    }

    public String getSelectedRowKeysAsString() {
        String value = null;
        Object selection = this.getSelection();
        String selectionMode = this.getSelectionMode();
        if (selection != null) {
            if ("single".equals(selectionMode)) {
                TreeNode node = (TreeNode)selection;
                value = node.getRowKey();
            } else {
                TreeNode[] nodes = (TreeNode[])selection;
                StringBuilder builder = SharedStringBuilder.get(SB_GET_SELECTED_ROW_KEYS_AS_STRING);
                for (int i = 0; i < nodes.length; ++i) {
                    builder.append(nodes[i].getRowKey());
                    if (i == nodes.length - 1) continue;
                    builder.append(",");
                }
                value = builder.toString();
            }
        }
        return value;
    }

    public String getContainerClientId(FacesContext context) {
        String clientId = super.getContainerClientId(context);
        String _rowKey = this.getRowKey();
        if (_rowKey == null) {
            return clientId;
        }
        StringBuilder builder = SharedStringBuilder.get(context, SB_GET_CONTAINER_CLIENT_ID);
        return builder.append(clientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(this.rowKey).toString();
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new WrapperEvent((UIComponent)this, event, this.getRowKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        TreeNode root = this.getValue();
        FacesContext context = this.getFacesContext();
        WrapperEvent wrapperEvent = (WrapperEvent)event;
        String oldRowKey = this.getRowKey();
        this.setRowKey(root, wrapperEvent.getRowKey());
        FacesEvent originalEvent = wrapperEvent.getFacesEvent();
        UIComponent source = (UIComponent)originalEvent.getSource();
        UIComponent compositeParent = null;
        try {
            if (!UIComponent.isCompositeComponent((UIComponent)source)) {
                compositeParent = UIComponent.getCompositeComponentParent((UIComponent)source);
            }
            if (compositeParent != null) {
                compositeParent.pushComponentToEL(context, null);
            }
            source.pushComponentToEL(context, null);
            source.broadcast(originalEvent);
        }
        finally {
            source.popComponentFromEL(context);
            if (compositeParent != null) {
                compositeParent.popComponentFromEL(context);
            }
        }
        this.setRowKey(root, oldRowKey);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.preDecode(context);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (saved == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
        this.processNodes(context, PhaseId.APPLY_REQUEST_VALUES, this.getValue());
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.popComponentFromEL(context);
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        Application application = context.getApplication();
        application.publishEvent(context, PreValidateEvent.class, (Object)this);
        this.preValidate(context);
        this.processNodes(context, PhaseId.PROCESS_VALIDATIONS, this.getValue());
        this.validateSelection(context);
        application.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    protected void validateSelection(FacesContext context) {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null && this.isRequired()) {
            boolean valid = true;
            Object selection = this.getSelection();
            if ("single".equals(selectionMode)) {
                if (selection == null) {
                    valid = false;
                }
            } else {
                TreeNode[] selectionArray = (TreeNode[])selection;
                if (selectionArray.length == 0) {
                    valid = false;
                }
            }
            if (!valid) {
                String requiredMessage = this.getRequiredMessage();
                FacesMessage msg = requiredMessage != null ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage) : MessageFactory.getFacesMessage(REQUIRED_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, this.getClientId(context));
                context.addMessage(this.getClientId(context), msg);
                context.validationFailed();
                context.renderResponse();
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.preUpdate(context);
        this.processNodes(context, PhaseId.UPDATE_MODEL_VALUES, this.getValue());
        this.updateSelection(context);
        this.popComponentFromEL(context);
    }

    public void updateSelection(FacesContext context) {
        String selectionMode = this.getSelectionMode();
        boolean propagateSelectionDown = this.isPropagateSelectionDown();
        boolean propagateSelectionUp = this.isPropagateSelectionUp();
        ValueExpression selectionVE = this.getValueExpression(PropertyKeys.selection.toString());
        if (selectionMode != null && selectionVE != null) {
            Object selection = this.getLocalSelectedNodes();
            Object previousSelection = selectionVE.getValue(context.getELContext());
            if ("single".equals(selectionMode)) {
                if (previousSelection != null) {
                    ((TreeNode)previousSelection).setSelected(false);
                }
                if (selection != null) {
                    ((TreeNode)selection).setSelected(true);
                }
            } else {
                TreeNode[] previousSelections = (TreeNode[])previousSelection;
                TreeNode[] selections = (TreeNode[])selection;
                if (previousSelections != null) {
                    for (TreeNode node : previousSelections) {
                        if (node instanceof CheckboxTreeNode) {
                            ((CheckboxTreeNode)node).setSelected(false, propagateSelectionDown, propagateSelectionUp);
                            continue;
                        }
                        node.setSelected(false);
                    }
                }
                if (selections != null) {
                    for (TreeNode node : selections) {
                        if (node instanceof CheckboxTreeNode) {
                            ((CheckboxTreeNode)node).setSelected(true, propagateSelectionDown, propagateSelectionUp);
                            continue;
                        }
                        node.setSelected(true);
                    }
                }
            }
            selectionVE.setValue(context.getELContext(), selection);
            this.setSelection(null);
        }
    }

    protected void processNodes(FacesContext context, PhaseId phaseId, TreeNode root) {
        if (this.isSkipChildren()) {
            return;
        }
        this.processFacets(context, phaseId, root);
        this.processColumnFacets(context, phaseId, root);
        if (root != null) {
            this.processNode(context, phaseId, root, root, null);
        }
        this.setRowKey(root, null);
    }

    protected void processNode(FacesContext context, PhaseId phaseId, TreeNode root, TreeNode treeNode, String rowKey) {
        this.processColumnChildren(context, phaseId, root, rowKey);
        if (this.shouldVisitNode(treeNode)) {
            int childIndex = 0;
            Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + SEPARATOR + childIndex;
                this.processNode(context, phaseId, root, iterator.next(), childRowKey);
                ++childIndex;
            }
        }
    }

    protected void processFacets(FacesContext context, PhaseId phaseId, TreeNode root) {
        this.setRowKey(root, null);
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected void processColumnFacets(FacesContext context, PhaseId phaseId, TreeNode root) {
        this.setRowKey(root, null);
        for (UIComponent child : this.getChildren()) {
            javax.faces.component.UIColumn column;
            if (!(child instanceof javax.faces.component.UIColumn) || !child.isRendered() || (column = (javax.faces.component.UIColumn)child).getFacetCount() <= 0) continue;
            for (UIComponent columnFacet : column.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    columnFacet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    columnFacet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    columnFacet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected void processColumnChildren(FacesContext context, PhaseId phaseId, TreeNode root, String nodeKey) {
        this.setRowKey(root, nodeKey);
        if (nodeKey == null) {
            return;
        }
        for (UIComponent child : this.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof javax.faces.component.UIColumn) {
                for (UIComponent grandkid : child.getChildren()) {
                    if (!grandkid.isRendered()) continue;
                    this.processComponent(context, grandkid, phaseId);
                }
                continue;
            }
            this.processComponent(context, child, phaseId);
        }
    }

    protected void processComponent(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        for (UIComponent child : this.getChildren()) {
            this.saveDescendantState(child, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            SavedState state = null;
            String clientId = component.getClientId(context);
            if (saved == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            if (state == null && (state = (SavedState)saved.get(clientId)) == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        }
        for (UIComponent uiComponent : component.getChildren()) {
            this.saveDescendantState(uiComponent, context);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        for (UIComponent child : this.getChildren()) {
            this.restoreDescendantState(child, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        }
        for (UIComponent kid : component.getChildren()) {
            this.restoreDescendantState(kid, context);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (!clientId.startsWith(this.getClientId(context))) {
            return false;
        }
        return super.invokeOnComponent(context, clientId, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        FacesContext facesContext = context.getFacesContext();
        boolean visitNodes = !ComponentUtils.isSkipIteration(context, facesContext);
        TreeNode root = this.getValue();
        String oldRowKey = this.getRowKey();
        if (visitNodes) {
            this.setRowKey(root, null);
        }
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.doVisitChildren(context)) {
                if (this.visitFacets(context, root, callback, visitNodes)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.requiresColumns() && this.visitColumnsAndColumnFacets(context, callback, visitNodes, root)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.visitNodes(context, root, callback, visitNodes)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
            if (visitNodes) {
                this.setRowKey(root, oldRowKey);
            }
        }
        return false;
    }

    protected boolean doVisitChildren(VisitContext context) {
        Collection idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
        return !idsToVisit.isEmpty();
    }

    protected boolean visitFacets(VisitContext context, TreeNode root, VisitCallback callback, boolean visitNodes) {
        if (visitNodes) {
            this.setRowKey(root, null);
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!facet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean visitColumns(VisitContext context, TreeNode root, VisitCallback callback, String rowKey, boolean visitNodes) {
        String treeNodeType = null;
        if (visitNodes) {
            this.setRowKey(root, rowKey);
            if (rowKey == null) {
                return false;
            }
            TreeNode rowNode = this.getRowNode();
            if (rowNode != null) {
                treeNodeType = rowNode.getType();
            }
        }
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Columns) {
                    Columns columns = (Columns)child;
                    for (int i = 0; i < columns.getRowCount(); ++i) {
                        columns.setRowIndex(i);
                        boolean value = this.visitColumnContent(context, callback, (UIComponent)columns);
                        if (!value) continue;
                        columns.setRowIndex(-1);
                        return true;
                    }
                    columns.setRowIndex(-1);
                    continue;
                }
                if (!(child instanceof javax.faces.component.UIColumn)) continue;
                if (child instanceof UITreeNode) {
                    UITreeNode uiTreeNode = (UITreeNode)child;
                    if (visitNodes && treeNodeType != null && !treeNodeType.equals(uiTreeNode.getType())) continue;
                }
                if (!child.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean visitColumnContent(VisitContext context, VisitCallback callback, UIComponent component) {
        if (component.getChildCount() > 0) {
            for (UIComponent grandkid : component.getChildren()) {
                if (!grandkid.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean visitNodes(VisitContext context, TreeNode root, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            if (root != null && this.visitNode(context, root, callback, root, null)) {
                return true;
            }
            this.setRowKey(root, null);
        } else if (this.visitColumns(context, root, callback, null, false)) {
            return true;
        }
        return false;
    }

    protected boolean visitNode(VisitContext context, TreeNode root, VisitCallback callback, TreeNode treeNode, String rowKey) {
        if (this.visitColumns(context, root, callback, rowKey, true)) {
            return true;
        }
        if (this.shouldVisitNode(treeNode)) {
            int childIndex = 0;
            Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey;
                String string = childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + SEPARATOR + childIndex;
                if (this.visitNode(context, root, callback, iterator.next(), childRowKey)) {
                    return true;
                }
                ++childIndex;
            }
        }
        return false;
    }

    protected boolean requiresColumns() {
        return false;
    }

    protected boolean visitColumnsAndColumnFacets(VisitContext context, VisitCallback callback, boolean visitRows, TreeNode root) {
        if (visitRows) {
            this.setRowKey(root, null);
        }
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                VisitResult result = context.invokeVisitCallback(child, callback);
                if (result == VisitResult.COMPLETE) {
                    return true;
                }
                if (child instanceof UIColumn) {
                    if (child.getFacetCount() <= 0) continue;
                    if (child instanceof Columns) {
                        Columns columns = (Columns)child;
                        for (int i = 0; i < columns.getRowCount(); ++i) {
                            columns.setRowIndex(i);
                            boolean value = this.visitColumnFacets(context, callback, child);
                            if (!value) continue;
                            return true;
                        }
                        columns.setRowIndex(-1);
                        continue;
                    }
                    boolean value = this.visitColumnFacets(context, callback, child);
                    if (!value) continue;
                    return true;
                }
                if (!(child instanceof ColumnGroup)) continue;
                this.visitColumnGroup(context, callback, (ColumnGroup)child);
            }
        }
        return false;
    }

    protected boolean visitColumnFacets(VisitContext context, VisitCallback callback, UIComponent component) {
        for (UIComponent columnFacet : component.getFacets().values()) {
            if (!columnFacet.visitTree(context, callback)) continue;
            return true;
        }
        return false;
    }

    protected boolean visitColumnGroup(VisitContext context, VisitCallback callback, ColumnGroup group) {
        if (group.getChildCount() > 0) {
            for (UIComponent row : group.getChildren()) {
                if (row.getChildCount() <= 0) continue;
                for (UIComponent col : row.getChildren()) {
                    boolean value;
                    if (!(col instanceof Column) || col.getFacetCount() <= 0 || !(value = this.visitColumnFacets(context, callback, col))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRTLRendering() {
        return this.rtl;
    }

    public void setRTLRendering(boolean rtl) {
        this.rtl = rtl;
    }

    protected boolean shouldVisitNode(TreeNode node) {
        return node.isExpanded() || node.getParent() == null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.preEncode(context);
        super.encodeBegin(context);
    }

    protected void preDecode(FacesContext context) {
    }

    protected void preValidate(FacesContext context) {
    }

    protected void preUpdate(FacesContext context) {
    }

    protected void preEncode(FacesContext context) {
    }

    protected Boolean isNestedWithinIterator() {
        if (this.isNested == null) {
            this.isNested = ComponentUtils.isNestedWithinIterator((UIComponent)this);
        }
        return this.isNested;
    }

    public static enum PropertyKeys {
        var,
        selectionMode,
        selection,
        saved,
        value,
        required,
        requiredMessage,
        skipChildren,
        showUnselectableCheckbox,
        nodeVar,
        propagateSelectionDown,
        propagateSelectionUp;

    }
}

