/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datascroller;

import java.util.Collection;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.context.FacesContext;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.datascroller.DataScrollerBase;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataScroller
extends DataScrollerBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataScroller";
    public static final String CONTAINER_CLASS = "ui-datascroller ui-widget";
    public static final String INLINE_CONTAINER_CLASS = "ui-datascroller ui-datascroller-inline ui-widget";
    public static final String HEADER_CLASS = "ui-datascroller-header ui-widget-header ui-corner-top";
    public static final String CONTENT_CLASS = "ui-datascroller-content ui-widget-content";
    public static final String LIST_CLASS = "ui-datascroller-list";
    public static final String ITEM_CLASS = "ui-datascroller-item";
    public static final String LOADER_CLASS = "ui-datascroller-loader";
    public static final String LOADING_CLASS = "ui-datascroller-loading";
    public static final String VIRTUALSCROLL_WRAPPER_CLASS = "ui-datascroller-virtualscroll-wrapper";
    private static final String DEFAULT_EVENT = "load";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("load", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public boolean isLoadRequest() {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_load");
    }

    public boolean isVirtualScrollingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_virtualScrolling");
    }

    @Override
    protected boolean shouldProcessChild(FacesContext context, int rowIndex, PhaseId phaseId) {
        if (this.isLoadRequest()) {
            String clientId = this.getClientId(context);
            int offset = Integer.parseInt((String)context.getExternalContext().getRequestParameterMap().get(clientId + "_offset"));
            return rowIndex < offset;
        }
        return super.shouldProcessChild(context, rowIndex, phaseId);
    }
}

