/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import javax.faces.FacesException;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableCSVExporter;
import org.primefaces.component.datatable.export.DataTableExcelExporter;
import org.primefaces.component.datatable.export.DataTableExcelXExporter;
import org.primefaces.component.datatable.export.DataTableExcelXStreamExporter;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.datatable.export.DataTablePDFExporter;
import org.primefaces.component.datatable.export.DataTableXMLExporter;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.ExporterType;

public class DataTableExporterFactory {
    private DataTableExporterFactory() {
    }

    public static Exporter<DataTable> getExporter(String type, ExporterOptions options) {
        DataTableExporter exporter = null;
        try {
            ExporterType exporterType = ExporterType.valueOf(type.toUpperCase());
            switch (exporterType) {
                case XLS: {
                    exporter = new DataTableExcelExporter();
                    break;
                }
                case PDF: {
                    exporter = new DataTablePDFExporter();
                    break;
                }
                case CSV: {
                    exporter = new DataTableCSVExporter();
                    break;
                }
                case XML: {
                    exporter = new DataTableXMLExporter();
                    break;
                }
                case XLSX: {
                    exporter = new DataTableExcelXExporter();
                    break;
                }
                case XLSXSTREAM: {
                    exporter = new DataTableExcelXStreamExporter();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new FacesException((Throwable)e);
        }
        return exporter;
    }
}

