/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import org.primefaces.component.export.ExporterOptions;

public class CSVOptions
implements ExporterOptions {
    public static final CSVOptions STANDARD = new CSVOptions('\"', ',', "\r\n");
    public static final CSVOptions EXCEL = new CSVOptions('\"', ',', "\n");
    public static final CSVOptions EXCEL_NORTHERN_EUROPE = new CSVOptions('\"', ';', "\n");
    public static final CSVOptions TABS = new CSVOptions('\"', '\t', "\n");
    private static final String STYLING_NOT_SUPPORTED = "CSV does not support styling.";
    private final char quoteChar;
    private final char delimiterChar;
    private final String endOfLineSymbols;
    private final String quoteString;
    private final String doubleQuoteString;

    public CSVOptions(char quoteChar, char delimiterChar, String endOfLineSymbols) {
        this.quoteChar = quoteChar;
        this.delimiterChar = delimiterChar;
        this.endOfLineSymbols = endOfLineSymbols;
        this.quoteString = Character.toString(quoteChar);
        this.doubleQuoteString = this.quoteString + this.quoteString;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getDelimiterChar() {
        return this.delimiterChar;
    }

    public String getEndOfLineSymbols() {
        return this.endOfLineSymbols;
    }

    public String getQuoteString() {
        return this.quoteString;
    }

    public String getDoubleQuoteString() {
        return this.doubleQuoteString;
    }

    @Override
    public String getFacetFontStyle() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getFacetFontColor() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getFacetBgColor() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getFacetFontSize() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getCellFontStyle() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getCellFontColor() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getCellFontSize() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }

    @Override
    public String getFontName() {
        throw new UnsupportedOperationException(STYLING_NOT_SUPPORTED);
    }
}

