/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.faces.context.FacesContext;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.primefaces.component.fileupload.AbstractFileUploadDecoder;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.file.NativeUploadedFile;
import org.primefaces.model.file.UploadedFile;

public class NativeFileUploadDecoder
extends AbstractFileUploadDecoder<HttpServletRequest> {
    @Override
    public String getName() {
        return "native";
    }

    @Override
    protected List<UploadedFile> createUploadedFiles(HttpServletRequest request, FileUpload fileUpload, String inputToDecodeId) throws IOException, ServletException {
        Long sizeLimit = fileUpload.getSizeLimit();
        Collection parts = request.getParts();
        return StreamSupport.stream(parts.spliterator(), false).filter(p -> p.getName().equals(inputToDecodeId)).map(p -> new NativeUploadedFile((Part)p, sizeLimit)).collect(Collectors.toList());
    }

    @Override
    protected UploadedFile createUploadedFile(HttpServletRequest request, FileUpload fileUpload, String inputToDecodeId) throws IOException, ServletException {
        Part part = request.getPart(inputToDecodeId);
        return new NativeUploadedFile(part, fileUpload.getSizeLimit());
    }

    @Override
    protected HttpServletRequest getRequest(FacesContext ctxt) {
        return (HttpServletRequest)ctxt.getExternalContext().getRequest();
    }

    @Override
    public String getUploadDirectory(HttpServletRequest request) {
        return Stream.of(request.getAttributeNames()).map(o -> request.getAttribute((String)o.nextElement())).filter(MultipartConfigElement.class::isInstance).map(MultipartConfigElement.class::cast).findFirst().map(MultipartConfigElement::getLocation).orElse(super.getUploadDirectory(request));
    }
}

