/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.hotkey;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.hotkey.Hotkey;
import org.primefaces.renderkit.CoreRenderer;

public class HotkeyRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Hotkey hotkey;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((hotkey = (Hotkey)component).getClientId(facesContext))) {
            hotkey.queueEvent((FacesEvent)new ActionEvent((UIComponent)hotkey));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Hotkey hotkey = (Hotkey)component;
        String clientId = hotkey.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String event = "keydown." + clientId;
        writer.write("$(function(){");
        if (!hotkey.isDisabled()) {
            writer.write("$(document).off('" + event + "').on('" + event + "',null,'" + hotkey.getBind() + "',function(){");
            if (hotkey.isAjaxified()) {
                String request = this.preConfiguredAjaxRequestBuilder(context, hotkey).params((UIComponent)hotkey).build();
                writer.write(request);
            } else {
                writer.write(hotkey.getHandler());
            }
            writer.write(";return false;});});");
        } else {
            writer.write("$(document).off('" + event + "')});");
        }
        writer.endElement("script");
    }
}

