/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.importconstants;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.component.importconstants.ConstantsHashMap;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.util.LangUtils;

public class ImportConstantsTagHandler
extends TagHandler {
    private final TagAttribute typeTagAttribute = super.getRequiredAttribute("type");
    private final TagAttribute varTagAttribute = super.getAttribute("var");

    public ImportConstantsTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Class<?> type = this.getClassFromAttribute(this.typeTagAttribute, ctx);
        Map<String, Object> constants = this.getConstants(facesContext, type);
        String var = this.varTagAttribute == null ? type.getSimpleName() : this.varTagAttribute.getValue(ctx);
        ctx.setAttribute(var, constants);
    }

    protected Class<?> getClassFromAttribute(TagAttribute attribute, FaceletContext ctx) {
        String type = attribute.getValue(ctx);
        try {
            return LangUtils.loadClassForName(type);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Class " + type + " not found.", (Throwable)e);
        }
    }

    protected Map<String, Object> getConstants(FacesContext facesContext, Class<?> type) {
        Map<String, Object> constants;
        boolean cacheEnabled = facesContext.isProjectStage(ProjectStage.Production);
        Map<Class<?>, Map<String, Object>> cache = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConstantsCacheMap();
        if (cacheEnabled && cache.containsKey(type)) {
            constants = cache.get(type);
        } else {
            constants = Collections.unmodifiableMap(ImportConstantsTagHandler.collectConstants(type));
            if (cacheEnabled) {
                cache.put(type, constants);
            }
        }
        return constants;
    }

    protected static Map<String, Object> collectConstants(Class<?> type) {
        Field[] fields;
        ConstantsHashMap<String, Object> constants = new ConstantsHashMap<String, Object>(type);
        for (Field field : fields = type.getFields()) {
            int modifiers;
            if (constants.containsKey(field.getName()) || !Modifier.isFinal(modifiers = field.getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            try {
                Object value = field.get(null);
                constants.put(field.getName(), value);
            }
            catch (Exception e) {
                throw new FacesException("Could not get value of " + field.getName() + " in " + type.getName() + ".", (Throwable)e);
            }
        }
        return constants;
    }
}

