/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tag.Tag;
import org.primefaces.renderkit.CoreRenderer;

public class TagRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tag tag = (Tag)component;
        ResponseWriter writer = context.getResponseWriter();
        String severity = tag.getSeverity();
        String styleClass = this.getStyleClassBuilder(context).add("ui-tag ui-widget").add(tag.getStyleClass()).add("info".equals(severity), "ui-tag-info").add("success".equals(severity), "ui-tag-success").add("warning".equals(severity), "ui-tag-warning").add("danger".equals(severity), "ui-tag-danger").add(tag.isRounded(), "ui-tag-rounded").build();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)tag.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (tag.getStyle() != null) {
            writer.writeAttribute("style", (Object)tag.getStyle(), "style");
        }
        if (tag.getChildCount() > 0) {
            this.renderChildren(context, (UIComponent)tag);
        } else {
            this.encodeDefaultContent(context, tag);
        }
        writer.endElement("span");
    }

    public void encodeDefaultContent(FacesContext context, Tag tag) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (tag.getIcon() != null) {
            String iconStyleClass = this.getStyleClassBuilder(context).add("ui-tag-icon").add(tag.getIcon()).build();
            writer.startElement("span", (UIComponent)tag);
            writer.writeAttribute("class", (Object)iconStyleClass, null);
            writer.endElement("span");
        }
        if (tag.getValue() != null) {
            writer.startElement("span", (UIComponent)tag);
            writer.writeAttribute("class", (Object)"ui-tag-value", null);
            writer.write(tag.getValue());
            writer.endElement("span");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

