/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tieredmenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.tieredmenu.TieredMenu;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class TieredMenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TieredMenu menu = (TieredMenu)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TieredMenu", menu).attr("autoDisplay", menu.isAutoDisplay()).attr("toggleEvent", menu.getToggleEvent(), null);
        if (menu.isOverlay()) {
            this.encodeOverlayConfig(context, menu, wb);
        }
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TieredMenu menu = (TieredMenu)abstractMenu;
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        String defaultStyleClass = menu.isOverlay() ? "ui-menu ui-tieredmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-tieredmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        this.encodeMenu(context, menu, style, styleClass, "menu");
    }

    protected void encodeMenu(FacesContext context, AbstractMenu menu, String style, String styleClass, String role) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent optionsFacet = menu.getFacet("options");
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeKeyboardTarget(context, menu);
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        if (menu.getElementsCount() > 0) {
            this.encodeElements(context, menu, menu.getElements());
        }
        if (ComponentUtils.shouldRenderFacet(optionsFacet)) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-menuitem ui-menubar-options ui-widget ui-corner-all", null);
            writer.writeAttribute("role", (Object)"none", null);
            optionsFacet.encodeAll(context);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeElements(FacesContext context, AbstractMenu menu, List<MenuElement> elements) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (MenuElement element : elements) {
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                String containerStyle = menuItem.getContainerStyle();
                String containerStyleClass = menuItem.getContainerStyleClass();
                containerStyleClass = containerStyleClass == null ? "ui-menuitem ui-widget ui-corner-all" : "ui-menuitem ui-widget ui-corner-all " + containerStyleClass;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)containerStyleClass, null);
                writer.writeAttribute("role", (Object)"none", null);
                if (containerStyle != null) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                this.encodeMenuItem(context, menu, menuItem, "-1");
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                Submenu submenu = (Submenu)element;
                String style = submenu.getStyle();
                String styleClass = submenu.getStyleClass();
                styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + styleClass;
                writer.startElement("li", null);
                if (this.shouldRenderId(submenu)) {
                    writer.writeAttribute("id", (Object)submenu.getClientId(), null);
                }
                writer.writeAttribute("class", (Object)styleClass, null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                writer.writeAttribute("role", (Object)"none", null);
                this.encodeSubmenu(context, menu, submenu);
                writer.endElement("li");
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeSubmenu(FacesContext context, AbstractMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        boolean disabled = submenu.isDisabled();
        writer.startElement("a", null);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        String styleClass = "ui-menuitem-link ui-submenu-link ui-corner-all";
        if (disabled) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (disabled) {
            writer.writeAttribute("onclick", (Object)"return false;", null);
        }
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.writeAttribute("aria-hidden", (Object)"true", null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)submenu.getLabel(), "value");
            writer.endElement("span");
        }
        this.encodeSubmenuIcon(context, submenu);
        writer.endElement("a");
        if (!disabled && submenu.getElementsCount() > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            this.encodeElements(context, menu, submenu.getElements());
            writer.endElement("ul");
        }
    }

    protected void encodeSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
    }
}

