/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.toggleswitch;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.toggleswitch.ToggleSwitch;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class ToggleSwitchRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)component;
        if (!this.shouldDecode(toggleSwitch)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)toggleSwitch);
        String clientId = toggleSwitch.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        boolean checked = this.isChecked(submittedValue);
        toggleSwitch.setSubmittedValue(checked);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ToggleSwitch toggleSwitch = (ToggleSwitch)component;
        this.encodeMarkup(context, toggleSwitch);
        this.encodeScript(context, toggleSwitch);
    }

    protected void encodeMarkup(FacesContext context, ToggleSwitch toggleSwitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = toggleSwitch.getClientId(context);
        boolean checked = Boolean.parseBoolean(ComponentUtils.getValueToRender(context, (UIComponent)toggleSwitch));
        boolean disabled = toggleSwitch.isDisabled();
        String style = toggleSwitch.getStyle();
        String styleClass = toggleSwitch.getStyleClass();
        styleClass = styleClass == null ? "ui-toggleswitch ui-widget" : "ui-toggleswitch ui-widget " + styleClass;
        String string = styleClass = checked ? styleClass + " " + "ui-toggleswitch-checked" : styleClass;
        if (disabled) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)toggleSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("role", (Object)"checkbox", null);
        writer.writeAttribute("aria-checked", (Object)checked, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, toggleSwitch, clientId, checked);
        this.encodeSlider(context);
        writer.endElement("div");
    }

    protected void encodeSlider(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-toggleswitch-slider", null);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, ToggleSwitch toggleSwitch, String clientId, boolean checked) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)toggleSwitch);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)toggleSwitch);
        this.renderAccessibilityAttributes(context, toggleSwitch);
        this.renderPassThruAttributes(context, (UIComponent)toggleSwitch, HTML.TAB_INDEX);
        this.renderOnchange(context, (UIComponent)toggleSwitch);
        this.renderDomEvents(context, (UIComponent)toggleSwitch, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ToggleSwitch toggleSwitch) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ToggleSwitch", toggleSwitch).finish();
    }

    protected boolean isChecked(String value) {
        return value != null && ("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }
}

