/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.convert.JQueryDateTimePatternBuilder;
import org.primefaces.convert.PatternReader;

public class CombinedDateTimePatternTokenVisitor
implements PatternReader.TokenVisitor {
    private static final Logger LOGGER = Logger.getLogger(CombinedDateTimePatternTokenVisitor.class.getName());
    private final JQueryDateTimePatternBuilder builder;

    public CombinedDateTimePatternTokenVisitor(JQueryDateTimePatternBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void visitLiteral(String text) {
        CombinedDateTimePatternTokenVisitor.visitLiteralToken(text, this.builder);
    }

    @Override
    public void visitTokenLetter(int letter, int repetitions) {
        switch (letter) {
            case 117: 
            case 121: {
                CombinedDateTimePatternTokenVisitor.visitYearToken(repetitions, this.builder);
                break;
            }
            case 77: {
                CombinedDateTimePatternTokenVisitor.visitMonthToken(repetitions, this.builder);
                break;
            }
            case 100: {
                CombinedDateTimePatternTokenVisitor.visitDayOfMonthToken(repetitions, this.builder);
                break;
            }
            case 68: {
                CombinedDateTimePatternTokenVisitor.visitDayOfYearToken(repetitions, this.builder);
                break;
            }
            case 69: {
                CombinedDateTimePatternTokenVisitor.visitDayOfWeekToken(repetitions, this.builder);
                break;
            }
            case 104: {
                CombinedDateTimePatternTokenVisitor.visitAmPmHourToken(repetitions, this.builder);
                break;
            }
            case 72: {
                CombinedDateTimePatternTokenVisitor.visitHourToken(repetitions, this.builder);
                break;
            }
            case 109: {
                CombinedDateTimePatternTokenVisitor.visitMinuteToken(repetitions, this.builder);
                break;
            }
            case 115: {
                CombinedDateTimePatternTokenVisitor.visitSecondToken(repetitions, this.builder);
                break;
            }
            case 83: {
                CombinedDateTimePatternTokenVisitor.visitMillisecondToken(repetitions, this.builder);
                break;
            }
            case 97: {
                CombinedDateTimePatternTokenVisitor.visitAmPmToken(repetitions, this.builder);
                break;
            }
            case 90: 
            case 122: {
                CombinedDateTimePatternTokenVisitor.visitZoneZToken(repetitions, this.builder);
                break;
            }
            case 88: {
                CombinedDateTimePatternTokenVisitor.visitZoneXToken(repetitions, this.builder);
                break;
            }
            default: {
                String letterString = Character.toString((char)letter);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Found unsupported letter '" + letterString + "' in pattern. Date / times will be formatted differently on the server and client. Use a different pattern.");
                }
                CombinedDateTimePatternTokenVisitor.visitDefault(letterString, repetitions, this.builder);
            }
        }
    }

    private static void visitAmPmHourToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendAmPmHourNoLeadingZeros();
        } else {
            builder.appendAmPmHourWithLeadingZeros();
        }
    }

    private static void visitAmPmToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        builder.appendAmPmLongUppercase();
    }

    private static void visitDayOfMonthToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendDayOfMonthNoLeadingZeros();
        } else {
            builder.appendDayOfMonthWithLeadingZeros();
        }
    }

    private static void visitDayOfWeekToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        switch (repetitions) {
            case 1: 
            case 2: 
            case 3: {
                builder.appendDayNameShort();
                break;
            }
            default: {
                builder.appendDayNameLong();
            }
        }
    }

    private static void visitDayOfYearToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendDayOfYearNoLeadingZeros();
        } else {
            builder.appendDayOfYearWithLeadingZeros();
        }
    }

    private static void visitHourToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendHourNoLeadingZeros();
        } else {
            builder.appendHourWithLeadingZeros();
        }
    }

    private static void visitLiteralToken(String text, JQueryDateTimePatternBuilder builder) {
        builder.appendLiteralText(text);
    }

    private static void visitMillisecondToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        builder.appendMillisecondsWithLeadingZeros();
    }

    private static void visitMinuteToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendMinuteNoLeadingZeros();
        } else {
            builder.appendMinuteWithLeadingZeros();
        }
    }

    private static void visitMonthToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        switch (repetitions) {
            case 1: {
                builder.appendMonthOfYearNoLeadingZeros();
                break;
            }
            case 2: {
                builder.appendMonthOfYearWithLeadingZeros();
                break;
            }
            case 3: {
                builder.appendMonthNameShort();
                break;
            }
            default: {
                builder.appendMonthNameLong();
            }
        }
    }

    private static void visitDefault(CharSequence string, int repetitions, JQueryDateTimePatternBuilder builder) {
        for (int i = 0; i < repetitions; ++i) {
            builder.getStringBuilder().append(string);
        }
    }

    private static void visitSecondToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 1) {
            builder.appendSecondNoLeadingZeros();
        } else {
            builder.appendSecondWithLeadingZeros();
        }
    }

    private static void visitYearToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        if (repetitions == 2) {
            builder.appendYearTwoDigits();
        } else {
            builder.appendYearFourDigits();
        }
    }

    private static void visitZoneXToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        switch (repetitions) {
            case 1: 
            case 2: {
                builder.appendTimezoneByProvidedTimezoneList();
                break;
            }
            default: {
                builder.appendTimezoneIso8601();
            }
        }
    }

    private static void visitZoneZToken(int repetitions, JQueryDateTimePatternBuilder builder) {
        builder.appendTimezoneByProvidedTimezoneList();
    }
}

