/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.convert.ConverterException;
import org.primefaces.convert.ClientConverter;
import org.primefaces.util.CalendarUtils;

public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter
implements ClientConverter {
    private Map<String, Object> metadata;

    @Override
    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            String pattern = this.getPattern();
            String type = this.getType();
            String dateStyle = this.getDateStyle();
            String timeStyle = this.getTimeStyle();
            this.metadata = new HashMap<String, Object>();
            if (pattern != null) {
                this.metadata.put("data-p-pattern", CalendarUtils.convertPattern(pattern));
            }
            if (type != null) {
                String typeCleared = type;
                if ("localDate".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "date";
                } else if ("localTime".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "time";
                } else if ("localDateTime".equalsIgnoreCase(typeCleared)) {
                    typeCleared = "both";
                }
                this.metadata.put("data-p-dttype", typeCleared);
                if (pattern == null) {
                    DateFormat df = null;
                    if ("both".equals(type)) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if ("date".equals(type)) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if ("time".equals(type)) {
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    }
                }
            }
        }
        return this.metadata;
    }

    @Override
    public String getConverterId() {
        return "javax.faces.DateTime";
    }

    private int getStyle(String style) {
        if ("default".equals(style)) {
            return 2;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("full".equals(style)) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + style + '\'');
    }
}

