/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.chart;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.primefaces.model.chart.AxisType;
import org.primefaces.util.EscapeUtils;

public class ChartSeries
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String label;
    private Map<Object, Number> data = new LinkedHashMap<Object, Number>();
    private AxisType xaxis;
    private AxisType yaxis;

    public ChartSeries() {
    }

    public ChartSeries(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<Object, Number> getData() {
        return this.data;
    }

    public void setData(Map<Object, Number> data) {
        this.data = data;
    }

    public void set(Object x, Number y) {
        this.data.put(x, y);
    }

    public String getRenderer() {
        return null;
    }

    public boolean isFill() {
        return false;
    }

    public AxisType getXaxis() {
        return this.xaxis;
    }

    public void setXaxis(AxisType xaxis) {
        this.xaxis = xaxis;
    }

    public AxisType getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(AxisType yaxis) {
        this.yaxis = yaxis;
    }

    public void encode(Writer writer) throws IOException {
        String renderer = this.getRenderer();
        writer.write("{");
        writer.write("label:\"" + EscapeUtils.forJavaScript(this.label) + "\"");
        if (renderer != null) {
            writer.write(",renderer: $.jqplot." + renderer);
        }
        if (this.xaxis != null) {
            writer.write(",xaxis:\"" + (Object)((Object)this.xaxis) + "\"");
        }
        if (this.yaxis != null) {
            writer.write(",yaxis:\"" + (Object)((Object)this.yaxis) + "\"");
        }
        writer.write("}");
    }
}

