/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.util.LangUtils;

public class BaseMenuModel
implements MenuModel,
Serializable {
    public static final String ID_SEPARATOR = "_";
    private static final long serialVersionUID = 1L;
    private List<MenuElement> elements = new ArrayList<MenuElement>();

    @Override
    public List<MenuElement> getElements() {
        return this.elements;
    }

    @Override
    public void generateUniqueIds() {
        this.generateUniqueIds(this.getElements(), null);
    }

    private void generateUniqueIds(List<MenuElement> elements, String seed) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int counter = 0;
        for (MenuElement element : elements) {
            String id = element.getId();
            if (LangUtils.isValueBlank(id)) {
                id = seed == null ? String.valueOf(counter++) : seed + ID_SEPARATOR + counter++;
                element.setId(id);
            }
            if (!(element instanceof MenuGroup)) continue;
            this.generateUniqueIds(((MenuGroup)element).getElements(), id);
        }
    }
}

