/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class OutcomeTargetRenderer
extends CoreRenderer {
    protected NavigationCase findNavigationCase(FacesContext context, UIOutcomeTarget outcomeTarget) {
        String toFlowDocumentId;
        ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcome = outcomeTarget.getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf22() && outcomeTarget instanceof UIComponent && (toFlowDocumentId = (String)((UIComponent)outcomeTarget).getAttributes().get("to-flow-document-id")) != null) {
            return navigationHandler.getNavigationCase(context, null, outcome, toFlowDocumentId);
        }
        return navigationHandler.getNavigationCase(context, null, outcome);
    }

    protected boolean isExpression(String text) {
        return text.contains("#{") || text.contains("${");
    }

    protected boolean containsEL(List<String> values) {
        if (!values.isEmpty()) {
            for (int i = 0; i < values.size(); ++i) {
                if (!this.isExpression(values.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> evaluateValueExpressions(FacesContext context, List<String> values) {
        ArrayList<String> target = new ArrayList<String>(values.size());
        for (String value : values) {
            if (this.isExpression(value)) {
                value = (String)context.getApplication().evaluateExpressionGet(context, value, String.class);
            }
            if (LangUtils.isValueEmpty(value)) continue;
            target.add(value);
        }
        return target;
    }

    protected Map<String, List<String>> getParams(FacesContext context, NavigationCase navCase, UIOutcomeTarget outcomeTarget) {
        String toFlowDocumentId;
        Map<String, List<String>> params = outcomeTarget.getParams();
        Map navCaseParams = navCase.getParameters();
        if (navCaseParams != null && !navCaseParams.isEmpty()) {
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            for (Map.Entry entry : navCaseParams.entrySet()) {
                String key = (String)entry.getKey();
                if (params.containsKey(key)) continue;
                List values = (List)entry.getValue();
                if (this.containsEL(values)) {
                    params.put(key, this.evaluateValueExpressions(context, values));
                    continue;
                }
                params.put(key, values);
            }
        }
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf22() && (toFlowDocumentId = navCase.getToFlowDocumentId()) != null) {
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            ArrayList<String> flowDocumentIdValues = new ArrayList<String>();
            flowDocumentIdValues.add(toFlowDocumentId);
            params.put("jftfdi", flowDocumentIdValues);
            if (!"javax.faces.flow.NullFlow".equals(toFlowDocumentId)) {
                ArrayList<String> flowIdValues = new ArrayList<String>();
                flowIdValues.add(navCase.getFromOutcome());
                params.put("jffi", flowIdValues);
            }
        }
        return params;
    }

    protected boolean isIncludeViewParams(UIOutcomeTarget outcomeTarget, NavigationCase navCase) {
        return outcomeTarget.isIncludeViewParams() || navCase.isIncludeViewParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getTargetURL(FacesContext context, UIOutcomeTarget outcomeTarget) {
        String url;
        boolean clientWindowRenderingModeEnabled = false;
        ClientWindow clientWindow = null;
        try {
            String href;
            if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf22() && outcomeTarget.isDisableClientWindow() && (clientWindow = context.getExternalContext().getClientWindow()) != null && (clientWindowRenderingModeEnabled = clientWindow.isClientWindowRenderModeEnabled(context))) {
                clientWindow.disableClientWindowRenderMode(context);
            }
            if ((href = outcomeTarget.getHref()) != null) {
                url = "#".equals(href) ? "#" : context.getExternalContext().encodeRedirectURL(href, outcomeTarget.getParams());
            } else {
                void var10_12;
                NavigationCase navCase = this.findNavigationCase(context, outcomeTarget);
                if (navCase == null) {
                    throw new FacesException("Could not resolve NavigationCase for outcome: " + outcomeTarget.getOutcome());
                }
                String toViewId = navCase.getToViewId(context);
                boolean isIncludeViewParams = this.isIncludeViewParams(outcomeTarget, navCase);
                Map<String, List<String>> map = this.getParams(context, navCase, outcomeTarget);
                if (map == null) {
                    Map map2 = Collections.emptyMap();
                }
                url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, (Map)var10_12, isIncludeViewParams);
                if (outcomeTarget.getFragment() != null) {
                    url = url + "#" + outcomeTarget.getFragment();
                }
            }
            if (!clientWindowRenderingModeEnabled || clientWindow == null) return url;
        }
        catch (Throwable throwable) {
            if (!clientWindowRenderingModeEnabled || clientWindow == null) throw throwable;
            ((ClientWindow)clientWindow).enableClientWindowRenderMode(context);
            throw throwable;
        }
        clientWindow.enableClientWindowRenderMode(context);
        return url;
    }
}

