package dao;

import dao.exception.PersistenceException;
import model.Customer;

import java.util.Collection;

public interface CustomerDAO {
    void createCustomer (Customer customer) throws PersistenceException;

    Collection<Customer> readCustomers () throws PersistenceException;

    Customer readCustomerById (int id) throws PersistenceException;

    void updateCustomer (Customer customer) throws PersistenceException;

    void deleteCustomer (Customer customer) throws PersistenceException;
}
