/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datascroller;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datascroller.DataScroller;
import org.primefaces.model.LazyDataModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class DataScrollerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataScroller ds = (DataScroller)component;
        if (ds.isLoadRequest()) {
            String clientId = ds.getClientId(context);
            int offset = Integer.parseInt((String)context.getExternalContext().getRequestParameterMap().get(clientId + "_offset"));
            this.loadChunk(context, ds, offset, ds.getChunkSize());
        } else {
            int chunkSize = ds.getChunkSize();
            if (chunkSize == 0) {
                chunkSize = ds.getRowCount();
            }
            this.encodeMarkup(context, ds, chunkSize);
            this.encodeScript(context, ds, chunkSize);
        }
    }

    protected void encodeMarkup(FacesContext context, DataScroller ds, int chunkSize) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ds.getClientId(context);
        boolean inline = ds.getMode().equals("inline");
        UIComponent header = ds.getFacet("header");
        UIComponent loader = ds.getFacet("loader");
        String contentCornerClass = null;
        String containerClass = inline ? "ui-datascroller ui-datascroller-inline ui-widget" : "ui-datascroller ui-widget";
        String style = ds.getStyle();
        String userStyleClass = ds.getStyleClass();
        String styleClass = userStyleClass == null ? containerClass : containerClass + " " + userStyleClass;
        writer.startElement("div", (UIComponent)ds);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)styleClass, null);
        }
        if (header != null && header.isRendered()) {
            writer.startElement("div", (UIComponent)ds);
            writer.writeAttribute("class", (Object)"ui-datascroller-header ui-widget-header ui-corner-top", null);
            header.encodeAll(context);
            writer.endElement("div");
            contentCornerClass = "ui-corner-bottom";
        } else {
            contentCornerClass = "ui-corner-all";
        }
        writer.startElement("div", (UIComponent)ds);
        writer.writeAttribute("class", (Object)("ui-datascroller-content ui-widget-content " + contentCornerClass), null);
        if (inline) {
            writer.writeAttribute("style", (Object)("height:" + ds.getScrollHeight() + "px"), null);
        }
        writer.startElement("ul", (UIComponent)ds);
        writer.writeAttribute("class", (Object)"ui-datascroller-list", null);
        this.loadChunk(context, ds, 0, chunkSize);
        ds.setRowIndex(-1);
        writer.endElement("ul");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datascroller-loader", null);
        if (loader != null && loader.isRendered()) {
            loader.encodeAll(context);
        }
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataScroller ds, int chunkSize) throws IOException {
        String clientId = ds.getClientId(context);
        String loadEvent = ds.getFacet("loader") == null ? "scroll" : "manual";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataScroller", ds.resolveWidgetVar(), clientId).attr("chunkSize", chunkSize).attr("totalSize", ds.getRowCount()).attr("loadEvent", loadEvent).attr("mode", ds.getMode(), "document").attr("buffer", ds.getBuffer()).finish();
    }

    protected void loadChunk(FacesContext context, DataScroller ds, int start, int size) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (ds.isLazy()) {
            this.loadLazyData(ds, start, size);
        }
        for (int i = start; i < start + size; ++i) {
            ds.setRowIndex(i);
            if (!ds.isRowAvailable()) break;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-datascroller-item", null);
            this.renderChildren(context, (UIComponent)ds);
            writer.endElement("li");
        }
        ds.setRowIndex(-1);
    }

    protected void loadLazyData(DataScroller ds, int start, int size) {
        LazyDataModel lazyModel = (LazyDataModel)ds.getValue();
        if (lazyModel != null) {
            List data = lazyModel.load(start, size, null, null, null);
            lazyModel.setPageSize(size);
            lazyModel.setWrappedData(data);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

