/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.util.ComponentUtils;

public class SelectionFeature
implements DataTableFeature {
    private static final String ALL_SELECTOR = "@all";

    public void decode(FacesContext context, DataTable table) {
        boolean isFiltered;
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        Object originalValue = table.getValue();
        List filteredValue = table.getFilteredValue();
        boolean bl = isFiltered = filteredValue != null;
        if (isFiltered) {
            table.setValue(null);
        }
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(table, selection);
        } else {
            this.decodeMultipleSelection(context, table, selection);
        }
        if (isFiltered) {
            table.setValue(originalValue);
        }
    }

    void decodeSingleSelection(DataTable table, String selection) {
        if (ComponentUtils.isValueBlank(selection)) {
            table.setSelection(null);
        } else {
            table.setSelection(table.getRowData(selection));
        }
    }

    void decodeMultipleSelection(FacesContext context, DataTable table, String selection) {
        boolean isArray;
        ValueExpression selectionByVE = table.getValueExpression("selection");
        Class clazz = selectionByVE == null ? null : selectionByVE.getType(context.getELContext());
        boolean bl = isArray = clazz == null ? false : clazz.isArray();
        if (clazz != null && !isArray && !List.class.isAssignableFrom(clazz)) {
            throw new FacesException("Multiple selection reference must be an Array or a List for datatable " + table.getClientId());
        }
        if (ComponentUtils.isValueBlank(selection)) {
            if (isArray) {
                table.setSelection(Array.newInstance(clazz.getComponentType(), 0));
            } else {
                table.setSelection(new ArrayList());
            }
        } else {
            ArrayList<Object> selectionList = new ArrayList<Object>();
            if (selection.equals(ALL_SELECTOR)) {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    table.setRowIndex(i);
                    selectionList.add(table.getRowData());
                }
            } else {
                String[] rowKeys = selection.split(",");
                for (int i = 0; i < rowKeys.length; ++i) {
                    Object rowData = table.getRowData(rowKeys[i]);
                    if (rowData == null) continue;
                    selectionList.add(rowData);
                }
            }
            if (isArray) {
                Object selectionArray = Array.newInstance(clazz.getComponentType(), selectionList.size());
                table.setSelection(selectionList.toArray((Object[])selectionArray));
            } else {
                table.setSelection(selectionList);
            }
        }
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("SelectFeature should not encode.");
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isSelectionEnabled();
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

