/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        this.configureResponse(externalContext, filename, encodingType);
        Writer writer = externalContext.getResponseOutputWriter();
        this.addColumnFacets(writer, table, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, writer);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, writer);
        } else {
            this.exportAll(context, table, writer);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(writer, table, Exporter.ColumnType.FOOTER);
        }
        writer.flush();
        writer.close();
        externalContext.responseFlushBuffer();
    }

    @Override
    public void export(FacesContext facesContext, List<String> clientIds, String outputFileName, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void export(FacesContext facesContext, String outputFileName, List<DataTable> tables, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void addColumnFacets(Writer writer, DataTable table, Exporter.ColumnType columnType) throws IOException {
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            UIComponent facet;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (firstCellWritten) {
                writer.write(",");
            }
            if ((facet = col.getFacet(columnType.facet())) != null) {
                this.addColumnValue(writer, facet);
            } else {
                String textValue;
                switch (columnType) {
                    case HEADER: {
                        textValue = col.getHeaderText();
                        break;
                    }
                    case FOOTER: {
                        textValue = col.getFooterText();
                        break;
                    }
                    default: {
                        textValue = "";
                    }
                }
                this.addColumnValue(writer, textValue);
            }
            firstCellWritten = true;
        }
        writer.write("\n");
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PrintWriter writer = (PrintWriter)document;
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (firstCellWritten) {
                writer.write(",");
            }
            try {
                this.addColumnValue(writer, col.getChildren(), col);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            firstCellWritten = true;
        }
    }

    protected void configureResponse(ExternalContext externalContext, String filename, String encodingType) {
        externalContext.setResponseContentType("text/csv; charset=" + encodingType);
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".csv");
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
    }

    protected void addColumnValues(Writer writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn col = iterator.next();
            this.addColumnValue(writer, col.getChildren(), col);
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
    }

    protected void addColumnValue(Writer writer, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(writer, value);
    }

    protected void addColumnValue(Writer writer, String value) throws IOException {
        value = value == null ? "" : value.replaceAll("\"", "\"\"");
        writer.write("\"" + value + "\"");
    }

    protected void addColumnValue(Writer writer, List<UIComponent> components, UIColumn column) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        writer.write("\"");
        if (column.getExportFunction() != null) {
            String value = this.exportColumnByFunction(context, column);
            value = value == null ? "" : value.replaceAll("\"", "\"\"");
            writer.write(value);
        } else {
            for (UIComponent component : components) {
                if (!component.isRendered()) continue;
                String value = this.exportValue(context, component);
                value = value == null ? "" : value.replaceAll("\"", "\"\"");
                writer.write(value);
            }
        }
        writer.write("\"");
    }

    @Override
    protected void postRowExport(DataTable table, Object document) {
        ((PrintWriter)document).write("\n");
    }
}

