/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.PDFExportVisitCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    private Font cellFont;
    private Font facetFont;

    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            document.add((Element)this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType));
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void export(FacesContext context, List<String> clientIds, String outputFileName, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, clientIds, null);
            PDFExportVisitCallback visitCallback = new PDFExportVisitCallback(this, document, pageOnly, selectionOnly, encodingType);
            context.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, outputFileName);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void export(FacesContext context, String outputFileName, List<DataTable> tables, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            for (DataTable table : tables) {
                document.add((Element)this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType));
                Paragraph preface = new Paragraph();
                this.addEmptyLine(preface, 3);
                document.add((Element)preface);
            }
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, outputFileName);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, String encoding) {
        int columnsCount = this.getColumnsCount(table);
        PdfPTable pdfTable = new PdfPTable(columnsCount);
        this.cellFont = FontFactory.getFont((String)"Times", (String)encoding);
        this.facetFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        this.addColumnFacets(table, pdfTable, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, pdfTable);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, pdfTable);
        } else {
            this.exportAll(context, table, pdfTable);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, pdfTable, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        return pdfTable;
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PdfPTable pdfTable = (PdfPTable)document;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont, col);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            UIComponent facet = col.getFacet(columnType.facet());
            if (facet != null) {
                this.addColumnValue(pdfTable, facet, this.facetFont);
                continue;
            }
            switch (columnType) {
                case HEADER: {
                    textValue = col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getFooterText();
                    break;
                }
                default: {
                    textValue = "";
                }
            }
            if (textValue == null) continue;
            pdfTable.addCell((Phrase)new Paragraph(textValue, this.facetFont));
        }
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component, Font font) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        pdfTable.addCell((Phrase)new Paragraph(value, font));
    }

    protected void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, Font font, UIColumn column) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (column.getExportFunction() != null) {
            pdfTable.addCell((Phrase)new Paragraph(this.exportColumnByFunction(context, column), font));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            pdfTable.addCell((Phrase)new Paragraph(builder.toString(), font));
        }
    }

    protected void writePDFToResponse(ExternalContext externalContext, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        externalContext.setResponseContentType("application/pdf");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        externalContext.setResponseContentLength(baos.size());
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        baos.writeTo(out);
        externalContext.responseFlushBuffer();
    }

    protected int getColumnsCount(DataTable table) {
        int count = 0;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            ++count;
        }
        return count;
    }

    protected void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Object)new Paragraph(" "));
        }
    }
}

