/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.context.RequestContext;
import org.primefaces.model.StreamedContent;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;
    private ValueExpression contentDisposition;

    public FileDownloadActionListener() {
    }

    public FileDownloadActionListener(ValueExpression value, ValueExpression contentDisposition) {
        this.value = value;
        this.contentDisposition = contentDisposition;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        if (content == null) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String contentDispositionValue = this.contentDisposition != null ? (String)this.contentDisposition.getValue(elContext) : "attachment";
        InputStream inputStream = null;
        try {
            int length;
            externalContext.setResponseContentType(content.getContentType());
            externalContext.setResponseHeader("Content-Disposition", contentDispositionValue + ";filename=\"" + content.getName() + "\"");
            externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
            if (RequestContext.getCurrentInstance().isSecure()) {
                externalContext.setResponseHeader("Cache-Control", "public");
                externalContext.setResponseHeader("Pragma", "public");
            }
            byte[] buffer = new byte[2048];
            inputStream = content.getStream();
            OutputStream outputStream = externalContext.getResponseOutputStream();
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            externalContext.setResponseStatus(200);
            externalContext.responseFlushBuffer();
            facesContext.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
        this.contentDisposition = (ValueExpression)values[1];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value, this.contentDisposition};
        return values;
    }

    public void setTransient(boolean value) {
    }
}

