/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultUploadedFile;
import org.primefaces.model.UploadedFileWrapper;
import org.primefaces.webapp.MultipartRequest;

public class CommonsFileUploadDecoder {
    public static void decode(FacesContext context, FileUpload fileUpload, String inputToDecodeId) {
        MultipartRequest multipartRequest = null;
        Object request = context.getExternalContext().getRequest();
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof MultipartRequest) {
                multipartRequest = (MultipartRequest)((Object)request);
                break;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (multipartRequest != null) {
            if (fileUpload.getMode().equals("simple")) {
                CommonsFileUploadDecoder.decodeSimple(context, fileUpload, multipartRequest, inputToDecodeId);
            } else {
                CommonsFileUploadDecoder.decodeAdvanced(context, fileUpload, multipartRequest);
            }
        }
    }

    private static void decodeSimple(FacesContext context, FileUpload fileUpload, MultipartRequest request, String inputToDecodeId) {
        FileItem file = request.getFileItem(inputToDecodeId);
        if (file != null) {
            if (file.getName().equals("")) {
                fileUpload.setSubmittedValue("");
            } else {
                fileUpload.setSubmittedValue(new UploadedFileWrapper(new DefaultUploadedFile(file)));
            }
        }
    }

    private static void decodeAdvanced(FacesContext context, FileUpload fileUpload, MultipartRequest request) {
        String clientId = fileUpload.getClientId(context);
        FileItem file = request.getFileItem(clientId);
        if (file != null) {
            fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, new DefaultUploadedFile(file)));
        }
    }
}

