/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import java.io.IOException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.DynamicResourceBuilder;
import org.primefaces.util.HTML;

public class GraphicImageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String imageSrc;
        ResponseWriter writer = context.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(context);
        try {
            imageSrc = this.getImageSrc(context, image);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)imageSrc, null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(context, (UIComponent)image, HTML.IMG_ATTRS);
        writer.endElement("img");
    }

    protected String getImageSrc(FacesContext context, GraphicImage image) throws Exception {
        String name = image.getName();
        if (name != null) {
            String libName = image.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        return DynamicResourceBuilder.build(context, image.getValue(), (UIComponent)image, image.isCache(), DynamicContentType.STREAMED_CONTENT, image.isStream());
    }
}

