/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.keyfilter;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.keyfilter.KeyFilter;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class KeyFilterRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        KeyFilter keyFilter = (KeyFilter)component;
        String target = SearchExpressionFacade.resolveClientIds(context, (UIComponent)keyFilter, keyFilter.getFor());
        if (this.isValueBlank(target)) {
            target = component.getParent().getClientId(context);
        }
        WidgetBuilder wb = RequestContext.getCurrentInstance().getWidgetBuilder();
        wb.initWithDomReady(KeyFilter.class.getSimpleName(), keyFilter.resolveWidgetVar(), keyFilter.getClientId(context));
        wb.attr("target", target);
        if (keyFilter.getRegEx() != null) {
            wb.nativeAttr("regEx", keyFilter.getRegEx());
        } else if (keyFilter.getInputRegEx() != null) {
            wb.nativeAttr("inputRegEx", keyFilter.getInputRegEx());
        } else if (keyFilter.getMask() != null) {
            wb.attr("mask", keyFilter.getMask());
        } else if (keyFilter.getTestFunction() != null) {
            wb.callback("testFunction", "function(c)", keyFilter.getTestFunction() + ";");
        }
        if (keyFilter.isPreventPaste()) {
            wb.attr("preventPaste", keyFilter.isPreventPaste());
        }
        wb.finish();
    }
}

