/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.ScheduleEntryMoveEvent;
import org.primefaces.event.ScheduleEntryResizeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="schedule/schedule.css"), @ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="moment/moment.js"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="schedule/schedule.js")})
public class Schedule
extends UIComponentBase
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Schedule";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.ScheduleRenderer";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put("dateSelect", SelectEvent.class);
            this.put("eventSelect", SelectEvent.class);
            this.put("eventMove", ScheduleEntryMoveEvent.class);
            this.put("eventResize", ScheduleEntryResizeEvent.class);
            this.put("viewChange", SelectEvent.class);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Locale appropriateLocale;
    private TimeZone appropriateTimeZone;

    public Schedule() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public ScheduleModel getValue() {
        return (ScheduleModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(ScheduleModel _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)_value);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object _locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), _locale);
    }

    public double getAspectRatio() {
        return (Double)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.aspectRatio), (Object)Double.MIN_VALUE);
    }

    public void setAspectRatio(double _aspectRatio) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.aspectRatio), (Object)_aspectRatio);
    }

    public String getView() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.view), (Object)"month");
    }

    public void setView(String _view) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.view), (Object)_view);
    }

    public Object getInitialDate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initialDate), null);
    }

    public void setInitialDate(Object _initialDate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.initialDate), _initialDate);
    }

    public boolean isShowWeekends() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showWeekends), (Object)true);
    }

    public void setShowWeekends(boolean _showWeekends) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showWeekends), (Object)_showWeekends);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isDraggable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggable), (Object)true);
    }

    public void setDraggable(boolean _draggable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggable), (Object)_draggable);
    }

    public boolean isResizable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizable), (Object)true);
    }

    public void setResizable(boolean _resizable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizable), (Object)_resizable);
    }

    public boolean isShowHeader() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showHeader), (Object)true);
    }

    public void setShowHeader(boolean _showHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showHeader), (Object)_showHeader);
    }

    public String getLeftHeaderTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.leftHeaderTemplate), (Object)"prev,next today");
    }

    public void setLeftHeaderTemplate(String _leftHeaderTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.leftHeaderTemplate), (Object)_leftHeaderTemplate);
    }

    public String getCenterHeaderTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.centerHeaderTemplate), (Object)"title");
    }

    public void setCenterHeaderTemplate(String _centerHeaderTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.centerHeaderTemplate), (Object)_centerHeaderTemplate);
    }

    public String getRightHeaderTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rightHeaderTemplate), (Object)"month,agendaWeek,agendaDay");
    }

    public void setRightHeaderTemplate(String _rightHeaderTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rightHeaderTemplate), (Object)_rightHeaderTemplate);
    }

    public boolean isAllDaySlot() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allDaySlot), (Object)true);
    }

    public void setAllDaySlot(boolean _allDaySlot) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allDaySlot), (Object)_allDaySlot);
    }

    public String getSlotDuration() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.slotDuration), (Object)"00:30:00");
    }

    public void setSlotDuration(String _slotDuration) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.slotDuration), (Object)_slotDuration);
    }

    public int getSlotMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.slotMinutes), (Object)30);
    }

    public void setSlotMinutes(int _slotMinutes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.slotMinutes), (Object)_slotMinutes);
    }

    public String getScrollTime() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollTime), (Object)"06:00:00");
    }

    public void setScrollTime(String _scrollTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollTime), (Object)_scrollTime);
    }

    public int getFirstHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.firstHour), (Object)6);
    }

    public void setFirstHour(int _firstHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.firstHour), (Object)_firstHour);
    }

    public String getMinTime() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minTime), null);
    }

    public void setMinTime(String _minTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minTime), (Object)_minTime);
    }

    public String getMaxTime() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxTime), null);
    }

    public void setMaxTime(String _maxTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxTime), (Object)_maxTime);
    }

    public String getAxisFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.axisFormat), null);
    }

    public void setAxisFormat(String _axisFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.axisFormat), (Object)_axisFormat);
    }

    public String getTimeFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeFormat), null);
    }

    public void setTimeFormat(String _timeFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeFormat), (Object)_timeFormat);
    }

    public String getColumnFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.columnFormat), null);
    }

    public void setColumnFormat(String _columnFormat) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.columnFormat), (Object)_columnFormat);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object _timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), _timeZone);
    }

    public String getClientTimeZone() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientTimeZone), null);
    }

    public void setClientTimeZone(String _clientTimeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientTimeZone), (Object)_clientTimeZone);
    }

    public boolean isIgnoreTimezone() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ignoreTimezone), (Object)true);
    }

    public void setIgnoreTimezone(boolean _ignoreTimezone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ignoreTimezone), (Object)_ignoreTimezone);
    }

    public boolean isTooltip() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tooltip), (Object)false);
    }

    public void setTooltip(boolean _tooltip) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tooltip), (Object)_tooltip);
    }

    public boolean isShowWeekNumbers() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showWeekNumbers), (Object)false);
    }

    public void setShowWeekNumbers(boolean _showWeekNumbers) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showWeekNumbers), (Object)_showWeekNumbers);
    }

    public String getExtender() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extender), null);
    }

    public void setExtender(String _extender) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.extender), (Object)_extender);
    }

    public String getDisplayEventEnd() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.displayEventEnd), null);
    }

    public void setDisplayEventEnd(String _displayEventEnd) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.displayEventEnd), (Object)_displayEventEnd);
    }

    public String getWeekNumberCalculation() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.weekNumberCalculation), (Object)"local");
    }

    public void setWeekNumberCalculation(String _weekNumberCalculation) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.weekNumberCalculation), (Object)_weekNumberCalculation);
    }

    public String getWeekNumberCalculator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.weekNumberCalculator), null);
    }

    public void setWeekNumberCalculator(String _weekNumberCalculator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.weekNumberCalculator), (Object)_weekNumberCalculator);
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Locale calculateLocale(FacesContext facesContext) {
        if (this.appropriateLocale != null) return this.appropriateLocale;
        Object userLocale = this.getLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                this.appropriateLocale = new Locale((String)userLocale, "");
                return this.appropriateLocale;
            } else {
                if (!(userLocale instanceof Locale)) throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for calendar:" + this.getClientId(facesContext));
                this.appropriateLocale = (Locale)userLocale;
            }
            return this.appropriateLocale;
        } else {
            this.appropriateLocale = facesContext.getViewRoot().getLocale();
        }
        return this.appropriateLocale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TimeZone calculateTimeZone() {
        if (this.appropriateTimeZone != null) return this.appropriateTimeZone;
        Object usertimeZone = this.getTimeZone();
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                this.appropriateTimeZone = TimeZone.getTimeZone((String)usertimeZone);
                return this.appropriateTimeZone;
            } else {
                if (!(usertimeZone instanceof TimeZone)) throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
                this.appropriateTimeZone = (TimeZone)usertimeZone;
            }
            return this.appropriateTimeZone;
        } else {
            this.appropriateTimeZone = DEFAULT_TIME_ZONE;
        }
        return this.appropriateTimeZone;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        TimeZone tz = this.calculateTimeZone();
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("dateSelect")) {
                Long milliseconds = Long.valueOf((String)params.get(clientId + "_selectedDate"));
                Calendar calendar = Calendar.getInstance(tz);
                calendar.setTimeInMillis(milliseconds - (long)tz.getOffset(milliseconds));
                Date selectedDate = calendar.getTime();
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedDate);
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                wrapperEvent = selectEvent;
            } else if (eventName.equals("eventSelect")) {
                String selectedEventId = (String)params.get(clientId + "_selectedEventId");
                ScheduleEvent selectedEvent = this.getValue().getEvent(selectedEventId);
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedEvent);
            } else if (eventName.equals("eventMove")) {
                String movedEventId = (String)params.get(clientId + "_movedEventId");
                ScheduleEvent movedEvent = this.getValue().getEvent(movedEventId);
                int dayDelta = Integer.valueOf((String)params.get(clientId + "_dayDelta"));
                int minuteDelta = Integer.valueOf((String)params.get(clientId + "_minuteDelta"));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(movedEvent.getStartDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                movedEvent.getStartDate().setTime(calendar.getTimeInMillis());
                calendar = Calendar.getInstance();
                calendar.setTime(movedEvent.getEndDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                movedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                wrapperEvent = new ScheduleEntryMoveEvent((UIComponent)this, behaviorEvent.getBehavior(), movedEvent, dayDelta, minuteDelta);
            } else if (eventName.equals("eventResize")) {
                String resizedEventId = (String)params.get(clientId + "_resizedEventId");
                ScheduleEvent resizedEvent = this.getValue().getEvent(resizedEventId);
                int dayDelta = Integer.valueOf((String)params.get(clientId + "_dayDelta"));
                int minuteDelta = Integer.valueOf((String)params.get(clientId + "_minuteDelta"));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(resizedEvent.getEndDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                resizedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                wrapperEvent = new ScheduleEntryResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), resizedEvent, dayDelta, minuteDelta);
            } else if (eventName.equals("viewChange")) {
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getView());
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent(wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ValueExpression expr = this.getValueExpression("view");
        if (expr != null) {
            expr.setValue(this.getFacesContext().getELContext(), (Object)this.getView());
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.view));
        }
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        value,
        locale,
        aspectRatio,
        view,
        initialDate,
        showWeekends,
        style,
        styleClass,
        draggable,
        resizable,
        showHeader,
        leftHeaderTemplate,
        centerHeaderTemplate,
        rightHeaderTemplate,
        allDaySlot,
        slotDuration,
        slotMinutes,
        scrollTime,
        firstHour,
        minTime,
        maxTime,
        axisFormat,
        timeFormat,
        columnFormat,
        timeZone,
        clientTimeZone,
        ignoreTimezone,
        tooltip,
        showWeekNumbers,
        extender,
        displayEventEnd,
        weekNumberCalculation,
        weekNumberCalculator;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

