/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectcheckboxmenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenu;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCheckboxMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectMany", "javax.faces.Checkbox", Renderer.class);
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectCheckboxMenu menu = (SelectCheckboxMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        boolean valid = menu.isValid();
        String title = menu.getTitle();
        String style = menu.getStyle();
        String styleclass = menu.getStyleClass();
        styleclass = styleclass == null ? "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all" : "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all " + styleclass;
        styleclass = menu.isDisabled() ? styleclass + " ui-state-disabled" : styleclass;
        styleclass = !valid ? styleclass + " ui-state-error" : styleclass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleclass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.encodeKeyboardTarget(context, menu);
        this.encodeInputs(context, menu, selectItems);
        this.encodeLabel(context, menu, selectItems, valid);
        this.encodeMenuIcon(context, menu, valid);
        writer.endElement("div");
    }

    protected void encodeInputs(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, values, submittedValues, converter, selectItem, ++idx);
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        String name = menu.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || menu.isDisabled();
        boolean escaped = option.isEscape();
        String itemLabel = option.getLabel();
        String string = itemLabel = this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean checked = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !checked) {
            return;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("data-escaped", (Object)String.valueOf(escaped), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (itemLabel.equals("&nbsp;")) {
            writer.write(itemLabel);
        } else if (escaped) {
            writer.writeText((Object)itemLabel, "value");
        } else {
            writer.write(itemLabel);
        }
        writer.endElement("label");
    }

    protected void encodeLabel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems, boolean valid) throws IOException {
        String labelClass;
        ResponseWriter writer = context.getResponseWriter();
        String label = menu.getLabel();
        String string = labelClass = !valid ? "ui-selectcheckboxmenu-label ui-corner-all ui-state-error" : "ui-selectcheckboxmenu-label ui-corner-all";
        if (label == null) {
            label = "&nbsp;";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-label-container", null);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelClass, null);
        writer.writeText((Object)label, null);
        writer.endElement("label");
        writer.endElement("span");
    }

    protected void encodeMenuIcon(FacesContext context, SelectCheckboxMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right" : "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("SelectCheckboxMenu", menu.resolveWidgetVar(), clientId).callback("onShow", "function()", menu.getOnShow()).callback("onHide", "function()", menu.getOnHide()).attr("scrollHeight", menu.getScrollHeight(), Integer.MAX_VALUE).attr("showHeader", menu.isShowHeader(), true).attr("updateLabel", menu.isUpdateLabel(), false).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)menu, menu.getAppendTo()), null);
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false);
        }
        wb.attr("panelStyle", menu.getPanelStyle(), null).attr("panelStyleClass", menu.getPanelStyleClass(), null);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    protected void encodeKeyboardTarget(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = menu.getClientId(context) + "_focus";
        String tabindex = menu.getTabindex();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", (UIComponent)menu);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("readonly", (Object)"readonly", null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

