/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanymenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectmanymenu.SelectManyMenu;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectManyMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectMany", "javax.faces.Menu", Renderer.class);
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyMenu menu = (SelectManyMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all" : "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = menu.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !menu.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (menu.isFilter()) {
            this.encodeFilter(context, menu);
        }
        this.encodeInput(context, menu, clientId, selectItems);
        this.encodeList(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyMenu menu) throws IOException {
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyMenu", menu.resolveWidgetVar(), clientId).attr("disabled", menu.isDisabled(), false).attr("showCheckbox", menu.isShowCheckbox(), false);
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false);
        }
        wb.finish();
    }

    protected void encodeInput(FacesContext context, SelectManyMenu menu, String clientId, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        String labelledBy = menu.getLabelledBy();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("size", (Object)"2", null);
        this.renderDomEvents(context, (UIComponent)menu, SelectManyMenu.DOM_EVENTS);
        if (labelledBy != null) {
            writer.writeAttribute("aria-labelledby", (Object)labelledBy, null);
        }
        if (menu.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)menu);
        }
        this.encodeSelectItems(context, menu, selectItems);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        boolean customContent = menu.getVar() != null;
        boolean showCheckbox = menu.isShowCheckbox();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-listcontainer", null);
        writer.writeAttribute("style", (Object)("height:" + this.calculateWrapperHeight(menu, selectItems.size())), null);
        if (customContent) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.startElement("tbody", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter, boolean customContent, boolean showCheckbox) throws IOException {
        Object itemValue;
        Object valuesArray;
        String itemClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean disabled = option.isDisabled() || menu.isDisabled();
        String string = itemClass = disabled ? "ui-selectlistbox-item ui-corner-all ui-state-disabled" : "ui-selectlistbox-item ui-corner-all";
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        if (selected) {
            itemClass = itemClass + " ui-state-highlight";
        }
        if (customContent) {
            String var = menu.getVar();
            context.getExternalContext().getRequestMap().put(var, option.getValue());
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (option.getDescription() != null) {
                writer.writeAttribute("title", (Object)option.getDescription(), null);
            }
            if (showCheckbox) {
                writer.startElement("td", null);
                RendererUtils.encodeCheckbox(context, selected);
                writer.endElement("td");
            }
            for (UIComponent child : menu.getChildren()) {
                if (!(child instanceof Column) || !child.isRendered()) continue;
                writer.startElement("td", null);
                this.renderChildren(context, child);
                writer.endElement("td");
            }
            writer.endElement("tr");
        } else {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (showCheckbox) {
                RendererUtils.encodeCheckbox(context, selected);
            }
            if (option.isEscape()) {
                writer.writeText((Object)option.getLabel(), null);
            } else {
                writer.write(option.getLabel());
            }
            writer.endElement("li");
        }
    }

    protected void encodeSelectItems(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.write(option.getLabel());
        writer.endElement("option");
    }

    protected void encodeFilter(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = menu.getClientId(context) + "_filter";
        boolean disabled = menu.isDisabled();
        String filterClass = disabled ? "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all ui-state-disabled" : "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-filter-container", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)filterClass, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected String calculateWrapperHeight(SelectManyMenu menu, int itemSize) {
        int height = menu.getScrollHeight();
        if (height != Integer.MAX_VALUE) {
            return height + "px";
        }
        if (itemSize > 10) {
            return "200px";
        }
        return "auto";
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context) + "_input";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public String getHighlighter() {
        return "listbox";
    }
}

