/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonebutton;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.primefaces.component.selectonebutton.SelectOneButton;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOneButtonRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectOne", "javax.faces.Radio", Renderer.class);
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneButton button = (SelectOneButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SelectOneButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        int selectItemsSize = selectItems.size();
        String style = button.getStyle();
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-selectonebutton ui-buttonset ui-widget ui-corner-all" : "ui-selectonebutton ui-buttonset ui-widget ui-corner-all " + styleClass;
        styleClass = styleClass + " ui-buttonset-" + selectItemsSize;
        styleClass = !button.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, button, selectItems);
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, SelectOneButton button, List<SelectItem> selectItems) throws IOException {
        int selectItemsSize = selectItems.size();
        Converter converter = button.getConverter();
        String name = button.getClientId(context);
        Object value = button.getSubmittedValue();
        if (value == null) {
            value = button.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            boolean disabled = selectItem.isDisabled() || button.isDisabled();
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + ++idx;
            Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
            boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
            this.encodeOption(context, button, selectItem, id, name, converter, selected, disabled, idx, selectItemsSize);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneButton button, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled, int idx, int size) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)button, converter, option.getValue());
        String buttonStyle = "ui-button ui-widget ui-state-default ui-button-text-only";
        if (size == 1) {
            buttonStyle = buttonStyle + " ui-corner-all";
        } else if (idx == 0) {
            buttonStyle = buttonStyle + " ui-corner-left";
        } else if (idx == size - 1) {
            buttonStyle = buttonStyle + " ui-corner-right";
        }
        buttonStyle = selected ? buttonStyle + " ui-state-active" : buttonStyle;
        buttonStyle = disabled ? buttonStyle + " ui-state-disabled" : buttonStyle;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)buttonStyle, null);
        writer.writeAttribute("tabindex", (Object)button.getTabindex(), null);
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)option.getLabel(), "itemLabel");
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectOneButton button) throws IOException {
        String clientId = button.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectOneButton", button.resolveWidgetVar(), clientId).callback("change", "function()", button.getOnchange());
        this.encodeClientBehaviors(context, button);
        wb.finish();
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context);
    }
}

