/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.context.RequestContext;
import org.primefaces.model.TreeNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class TreeRenderer
extends CoreRenderer {
    private static final String SB_DECODE_SELECTION = TreeRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        Tree tree = (Tree)component;
        if (tree.isDragDropRequest(context)) {
            this.decodeDragDrop(context, tree);
        }
        if (tree.getSelectionMode() != null) {
            this.decodeSelection(context, tree);
        }
        this.decodeBehaviors(context, (UIComponent)tree);
    }

    public void decodeSelection(FacesContext context, Tree tree) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        String selection = (String)params.get(clientId + "_selection");
        boolean isSingle = tree.getSelectionMode().equalsIgnoreCase("single");
        if (this.isValueBlank(selection)) {
            if (isSingle) {
                tree.setSelection(null);
            } else {
                tree.setSelection(new TreeNode[0]);
            }
        } else {
            String[] selectedRowKeys = selection.split(",");
            if (isSingle) {
                tree.setRowKey(selectedRowKeys[0]);
                tree.setSelection(tree.getRowNode());
            } else {
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (int i = 0; i < selectedRowKeys.length; ++i) {
                    tree.setRowKey(selectedRowKeys[i]);
                    TreeNode rowNode = tree.getRowNode();
                    if (rowNode == null) continue;
                    selectedNodes.add(rowNode);
                }
                tree.setSelection(selectedNodes.toArray(new TreeNode[selectedNodes.size()]));
            }
            tree.setRowKey(null);
        }
        if (tree.isCheckboxSelection() && tree.isDynamic() && tree.isSelectionRequest(context) && tree.isPropagateSelectionDown()) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tree.setRowKey(selectedNodeRowKey);
            TreeNode selectedNode = tree.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tree.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            RequestContext.getCurrentInstance().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void decodeDragDrop(FacesContext context, Tree tree) {
        TreeNode dropNode;
        TreeNode dragNode;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        String dragNodeRowKey = (String)params.get(clientId + "_dragNode");
        String dropNodeRowKey = (String)params.get(clientId + "_dropNode");
        String dragSource = (String)params.get(clientId + "_dragSource");
        int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
        if (dragSource.equals(clientId)) {
            tree.setRowKey(dragNodeRowKey);
            dragNode = tree.getRowNode();
        } else {
            Tree otherTree = (Tree)tree.findComponent(":" + dragSource);
            otherTree.setRowKey(dragNodeRowKey);
            dragNode = otherTree.getRowNode();
        }
        if (this.isValueBlank(dropNodeRowKey)) {
            dropNode = tree.getValue();
        } else {
            tree.setRowKey(dropNodeRowKey);
            dropNode = tree.getRowNode();
        }
        tree.setDragNode(dragNode);
        tree.setDropNode(dropNode);
        if (dndIndex >= 0 && dndIndex < dropNode.getChildCount()) {
            dropNode.getChildren().add(dndIndex, dragNode);
        } else {
            dropNode.getChildren().add(dragNode);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        if (tree.isNodeExpandRequest(context)) {
            boolean vertical = tree.getOrientation().equals("vertical");
            String clientId = tree.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String rowKey = (String)params.get(clientId + "_expandNode");
            if (!vertical && rowKey.equals("root")) {
                this.encodeHorizontalTreeNodeChildren(context, tree, tree.getValue(), tree.getClientId(context), null, tree.isDynamic(), tree.isCheckboxSelection());
            } else {
                tree.setRowKey(rowKey);
                TreeNode node = tree.getRowNode();
                node.setExpanded(true);
                if (vertical) {
                    this.encodeTreeNodeChildren(context, tree, node, clientId, tree.isDynamic(), tree.isCheckboxSelection(), tree.isDroppable());
                } else {
                    this.encodeHorizontalTreeNodeChildren(context, tree, node, tree.getClientId(context), rowKey, tree.isDynamic(), tree.isCheckboxSelection());
                }
                tree.setRowKey(null);
            }
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    protected void encodeScript(FacesContext context, Tree tree) throws IOException {
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        String widget = tree.getOrientation().equals("vertical") ? "VerticalTree" : "HorizontalTree";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady(widget, tree.resolveWidgetVar(), clientId);
        wb.attr("dynamic", dynamic).attr("highlight", tree.isHighlight(), true).attr("animate", tree.isAnimate(), false).attr("droppable", tree.isDroppable(), false).attr("cache", tree.isCache() && dynamic).attr("dragdropScope", tree.getDragdropScope(), null).callback("onNodeClick", "function(node, event)", tree.getOnNodeClick());
        if (selectionMode != null) {
            wb.attr("selectionMode", selectionMode);
            wb.attr("propagateUp", tree.isPropagateSelectionUp());
            wb.attr("propagateDown", tree.isPropagateSelectionDown());
        }
        if (tree.isDraggable()) {
            wb.attr("draggable", true).attr("dragMode", tree.getDragMode()).attr("dropRestrict", tree.getDropRestrict());
        }
        this.encodeIconStates(context, tree, wb);
        this.encodeClientBehaviors(context, tree);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Tree tree) throws IOException {
        boolean vertical = tree.getOrientation().equals("vertical");
        TreeNode root = tree.getValue();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (vertical) {
            this.encodeVerticalTree(context, tree, root);
        } else {
            this.encodeHorizontalTree(context, tree, root);
        }
    }

    public void encodeVerticalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        String containerClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean selectable = selectionMode != null;
        boolean multiselectable = selectable && selectionMode.equals("single");
        boolean checkbox = selectable && selectionMode.equals("checkbox");
        boolean droppable = tree.isDroppable();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (ComponentUtils.isRTL(context, tree)) {
            tree.setRTLRendering(true);
        }
        String string = containerClass = tree.isRTLRendering() ? Tree.CONTAINER_RTL_CLASS : Tree.CONTAINER_CLASS;
        if (tree.getStyleClass() != null) {
            containerClass = containerClass + " " + tree.getStyleClass();
        }
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        writer.writeAttribute("tabindex", (Object)tree.getTabindex(), null);
        writer.writeAttribute("aria-multiselectable", (Object)String.valueOf(multiselectable), null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)Tree.ROOT_NODES_CLASS, null);
        if (root != null) {
            this.encodeTreeNodeChildren(context, tree, root, clientId, dynamic, checkbox, droppable);
        }
        writer.endElement("ul");
        if (selectable) {
            this.encodeSelectionHolder(context, tree);
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        String containerClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean checkbox = selectionMode != null && selectionMode.equals("checkbox");
        String string = containerClass = tree.getStyleClass() == null ? Tree.HORIZONTAL_CONTAINER_CLASS : Tree.HORIZONTAL_CONTAINER_CLASS + " " + tree.getStyleClass();
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        if (root != null) {
            this.encodeHorizontalTreeNode(context, tree, root, clientId, null, NodeOrder.NONE, dynamic, checkbox);
        }
        if (selectionMode != null) {
            this.encodeSelectionHolder(context, tree);
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, NodeOrder nodeOrder, boolean dynamic, boolean checkbox) throws IOException {
        String nodeContentClass;
        String nodeClass;
        ResponseWriter writer = context.getResponseWriter();
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        boolean expanded = node.isExpanded();
        boolean leaf = node.isLeaf();
        boolean selectable = node.isSelectable();
        boolean partialSelected = node.isPartialSelected();
        boolean selected = node.isSelected();
        if (leaf) {
            nodeClass = Tree.LEAF_NODE_CLASS;
        } else {
            nodeClass = Tree.PARENT_NODE_CLASS;
            String string = nodeClass = expanded ? nodeClass + " ui-treenode-expanded" : nodeClass + " ui-treenode-collapsed";
        }
        nodeClass = selected ? nodeClass + " ui-treenode-selected" : (partialSelected ? nodeClass + " ui-treenode-hasselected" : nodeClass + " ui-treenode-unselected");
        writer.startElement("table", (UIComponent)tree);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (nodeOrder != NodeOrder.NONE) {
            this.encodeConnector(context, tree, nodeOrder);
        }
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)nodeClass, null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        if (rowKey != null) {
            tree.setRowKey(rowKey);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        } else {
            context.getExternalContext().getRequestMap().put(tree.getVar(), tree.getValue().getData());
            writer.writeAttribute("data-rowkey", (Object)"root", null);
        }
        String string = nodeContentClass = node.isSelectable() ? Tree.SELECTABLE_NODE_CONTENT_CLASS_H : Tree.NODE_CONTENT_CLASS_H;
        if (selected) {
            nodeContentClass = nodeContentClass + " ui-state-highlight";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)nodeContentClass, null);
        if (!leaf) {
            String toggleIcon = expanded ? Tree.EXPANDED_ICON_CLASS_H : Tree.COLLAPSED_ICON_CLASS_H;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleIcon, null);
            writer.endElement("span");
        }
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        uiTreeNode.encodeAll(context);
        writer.endElement("div");
        writer.endElement("td");
        if (!leaf) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children-container", null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)Tree.CHILDREN_NODES_CLASS, null);
            if (dynamic && expanded || !dynamic) {
                this.encodeHorizontalTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeHorizontalTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        int childIndex = 0;
        Iterator<TreeNode> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            NodeOrder no = null;
            no = node.getChildCount() == 1 ? NodeOrder.NONE : (childIndex == 0 ? NodeOrder.FIRST : (childIndex == node.getChildCount() - 1 ? NodeOrder.LAST : NodeOrder.MIDDLE));
            this.encodeHorizontalTreeNode(context, tree, iterator.next(), clientId, childRowKey, no, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeConnector(FacesContext context, Tree tree, NodeOrder nodeOrder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector-table", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.FIRST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.LAST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("td");
    }

    public void encodeTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, boolean dynamic, boolean checkbox, boolean dragdrop) throws IOException {
        String contentClass;
        String containerClass;
        String rowKey = node.getRowKey();
        boolean selected = node.isSelected();
        boolean partialSelected = node.isPartialSelected();
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        if (!uiTreeNode.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        tree.setRowKey(rowKey);
        boolean isLeaf = node.isLeaf();
        boolean expanded = node.isExpanded();
        boolean selectable = node.isSelectable();
        String toggleIcon = expanded ? Tree.EXPANDED_ICON_CLASS_V : (tree.isRTLRendering() ? Tree.COLLAPSED_ICON_RTL_CLASS_V : Tree.COLLAPSED_ICON_CLASS_V);
        String stateIcon = isLeaf ? Tree.LEAF_ICON_CLASS : toggleIcon;
        Object datakey = tree.getDatakey();
        String nodeId = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + rowKey;
        String string = containerClass = isLeaf ? Tree.LEAF_NODE_CLASS : Tree.PARENT_NODE_CLASS;
        containerClass = selected ? containerClass + " ui-treenode-selected" : (partialSelected ? containerClass + " ui-treenode-hasselected" : containerClass + " ui-treenode-unselected");
        containerClass = uiTreeNode.getStyleClass() == null ? containerClass : containerClass + " " + uiTreeNode.getStyleClass();
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)nodeId, null);
        writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (datakey != null) {
            writer.writeAttribute("data-datakey", datakey, null);
        }
        String string2 = contentClass = selectable ? Tree.SELECTABLE_NODE_CONTENT_CLASS_V : Tree.NODE_CONTENT_CLASS_V;
        if (dragdrop) {
            contentClass = contentClass + " ui-treenode-droppable";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        if (checkbox) {
            writer.writeAttribute("aria-checked", (Object)String.valueOf(selected), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)stateIcon, null);
        writer.endElement("span");
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        String nodeLabelClass = selected ? Tree.NODE_LABEL_CLASS + " ui-state-highlight" : Tree.NODE_LABEL_CLASS;
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)nodeLabelClass, null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("role", (Object)"treeitem", null);
        writer.writeAttribute("aria-label", (Object)uiTreeNode.getAriaLabel(), null);
        uiTreeNode.encodeAll(context);
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)Tree.CHILDREN_NODES_CLASS, null);
        writer.writeAttribute("role", (Object)"group", null);
        if (!expanded) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (dynamic && expanded || !dynamic) {
            this.encodeTreeNodeChildren(context, tree, node, clientId, dynamic, checkbox, dragdrop);
        }
        writer.endElement("ul");
        writer.endElement("li");
        if (dragdrop) {
            this.encodeDropTarget(context, tree);
        }
    }

    public void encodeTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, boolean dynamic, boolean checkbox, boolean droppable) throws IOException {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                if (i == 0 && droppable) {
                    this.encodeDropTarget(context, tree);
                }
                this.encodeTreeNode(context, tree, node.getChildren().get(i), clientId, dynamic, checkbox, droppable);
            }
        }
    }

    protected void encodeDropTarget(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-tree-droppoint", null);
        writer.endElement("li");
    }

    protected void encodeIconStates(FacesContext context, Tree tree, WidgetBuilder wb) throws IOException {
        Map<String, UITreeNode> nodes = tree.getTreeNodes();
        wb.append(",iconStates:{");
        boolean firstWritten = false;
        for (String type : nodes.keySet()) {
            UITreeNode node = nodes.get(type);
            String expandedIcon = node.getExpandedIcon();
            String collapsedIcon = node.getCollapsedIcon();
            if (expandedIcon == null || collapsedIcon == null) continue;
            if (firstWritten) {
                wb.append(",");
            }
            wb.append("'" + node.getType() + "' : {");
            wb.append("expandedIcon:'" + expandedIcon + "'");
            wb.append(",collapsedIcon:'" + collapsedIcon + "'");
            wb.append("}");
            firstWritten = true;
        }
        wb.append("}");
    }

    protected void encodeIcon(FacesContext context, UITreeNode uiTreeNode, boolean expanded) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        String icon = uiTreeNode.getIconToRender(expanded);
        if (icon != null) {
            writer.writeAttribute("class", (Object)(Tree.NODE_ICON_CLASS + " " + icon), null);
        }
        writer.endElement("span");
    }

    protected void encodeSelectionHolder(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = tree.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)tree.getSelectedRowKeysAsString(), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.endElement("input");
    }

    protected void encodeCheckbox(FacesContext context, Tree tree, TreeNode node, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = selected ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox-box ui-widget ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NodeOrder {
        FIRST,
        MIDDLE,
        LAST,
        NONE;

    }
}

