/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata;

import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.context.FacesContext;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.primefaces.context.RequestContext;
import org.primefaces.el.ValueExpressionAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationMetadataExtractor {
    public static Set<ConstraintDescriptor<?>> extractAllConstraintDescriptors(FacesContext context, RequestContext requestContext, ValueExpression ve) {
        PropertyDescriptor propertyDescriptor = BeanValidationMetadataExtractor.extractPropertyDescriptor(context, requestContext, ve);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getConstraintDescriptors();
        }
        return null;
    }

    public static Set<ConstraintDescriptor<?>> extractDefaultConstraintDescriptors(FacesContext context, RequestContext requestContext, ValueExpression ve) {
        return BeanValidationMetadataExtractor.extractConstraintDescriptors(context, requestContext, ve, Default.class);
    }

    public static Set<ConstraintDescriptor<?>> extractConstraintDescriptors(FacesContext context, RequestContext requestContext, ValueExpression ve, Class ... groups) {
        PropertyDescriptor propertyDescriptor = BeanValidationMetadataExtractor.extractPropertyDescriptor(context, requestContext, ve);
        if (propertyDescriptor != null) {
            return propertyDescriptor.findConstraints().unorderedAndMatchingGroups(groups).getConstraintDescriptors();
        }
        return null;
    }

    public static PropertyDescriptor extractPropertyDescriptor(FacesContext context, RequestContext requestContext, ValueExpression ve) {
        ELContext elContext;
        ValueReference vr;
        if (ve != null && (vr = ValueExpressionAnalyzer.getReference(elContext = context.getELContext(), ve)) != null) {
            BeanDescriptor beanDescriptor;
            Validator validator = requestContext.getApplicationContext().getValidator();
            Object base = vr.getBase();
            Object property = vr.getProperty();
            if (base != null && property != null && (beanDescriptor = validator.getConstraintsForClass(base.getClass())) != null) {
                return beanDescriptor.getConstraintsForProperty(property.toString());
            }
        }
        return null;
    }
}

