/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectmanybutton.SelectManyButton;

public class SelectManyButtonRenderer
extends org.primefaces.component.selectmanybutton.SelectManyButtonRenderer {
    public void encodeMarkup(FacesContext context, SelectManyButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        String style = button.getStyle();
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanybutton ui-controlgroup ui-controlgroup-horizontal ui-corner-all" : "ui-selectmanybutton ui-controlgroup ui-controlgroup-horizontal ui-corner-all " + styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-controlgroup-controls", "id");
        if (selectItems != null && !selectItems.isEmpty()) {
            int itemCount = selectItems.size();
            Converter converter = button.getConverter();
            Object values = this.getValues((UIComponent)button);
            Object submittedValues = this.getSubmittedValues((UIComponent)button);
            for (int idx = 0; idx < itemCount; ++idx) {
                SelectItem selectItem = selectItems.get(idx);
                String labelClass = idx == 0 ? "ui-first-child" : (idx == itemCount - 1 ? "ui-last-child" : null);
                this.encodeOption(context, (UIInput)button, values, submittedValues, converter, selectItem, idx, labelClass);
            }
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx, String labelClass) throws IOException {
        String labelStyleClass;
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyButton button = (SelectManyButton)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = button.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || button.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        String string = labelStyleClass = labelClass == null ? "ui-btn ui-corner-all ui-btn-inherit" : "ui-btn ui-corner-all ui-btn-inherit " + labelClass;
        if (selected) {
            labelStyleClass = labelStyleClass + " ui-btn-active";
        }
        if (disabled) {
            labelStyleClass = labelStyleClass + " ui-state-disabled";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-checkbox", null);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelStyleClass, null);
        writer.writeAttribute("for", (Object)id, null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("data-role", (Object)"none", null);
        this.renderOnchange(context, (UIComponent)button);
        this.renderDynamicPassThruAttributes(context, (UIComponent)button);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

