/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectmanycheckbox.SelectManyCheckbox;
import org.primefaces.util.WidgetBuilder;

public class SelectManyCheckboxRenderer
extends org.primefaces.component.selectmanycheckbox.SelectManyCheckboxRenderer {
    protected void encodeScript(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        String clientId = checkbox.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyCheckbox", checkbox.resolveWidgetVar(), clientId).finish();
    }

    protected void encodeMarkup(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (selectItems != null && !selectItems.isEmpty()) {
            Converter converter = checkbox.getConverter();
            Object values = this.getValues((UIComponent)checkbox);
            Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
            int idx = 0;
            for (SelectItem selectItem : selectItems) {
                this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
                ++idx;
            }
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyCheckbox checkbox = (SelectManyCheckbox)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = checkbox.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || checkbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        this.renderOnchange(context, (UIComponent)checkbox);
        this.renderDynamicPassThruAttributes(context, (UIComponent)checkbox);
        if (checkbox.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)checkbox.getTabindex(), null);
        }
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }
}

