/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.managed.Invoker;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.util.IOUtils;
import org.primefaces.push.EventBus;
import org.primefaces.push.RemoteEndpoint;
import org.primefaces.push.Status;
import org.primefaces.push.annotation.OnClose;
import org.primefaces.push.annotation.OnMessage;
import org.primefaces.push.annotation.OnOpen;
import org.primefaces.push.annotation.PathParam;
import org.primefaces.push.impl.RemoteEndpointImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushEndpointHandlerProxy
extends AbstractReflectorAtmosphereHandler
implements AnnotatedProxy {
    private Logger logger = LoggerFactory.getLogger(PushEndpointHandlerProxy.class);
    private Object proxiedInstance;
    private List<Method> onMessageMethods;
    private Method onCloseMethod;
    private Method onTimeoutMethod;
    private Method onOpenMethod;
    private Method onResumeMethod;
    private AtmosphereConfig config;
    private EventBus eventBus;
    private boolean injectEventBus = false;
    private boolean injectEndpoint = false;
    private boolean pathParams;
    final Map<Method, List<Encoder<?, ?>>> encoders = new HashMap();
    final Map<Method, List<Decoder<?, ?>>> decoders = new HashMap();
    private final Set<String> trackedUUID = Collections.synchronizedSet(new HashSet());
    private final BroadcastFilter onMessageFilter = new BroadcastFilter(){

        public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
            return PushEndpointHandlerProxy.this.invoke(null, originalMessage, message);
        }

        public BroadcastFilter.BroadcastAction filter(String broadccasterId, Object originalMessage, Object message) {
            return this.filter(originalMessage, message);
        }
    };
    private final BroadcastFilter onPerMessageFilter = new PerRequestBroadcastFilter(){

        public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
            return PushEndpointHandlerProxy.this.invoke(null, originalMessage, message);
        }

        public BroadcastFilter.BroadcastAction filter(AtmosphereResource r, Object originalMessage, Object message) {
            RemoteEndpointImpl rm = (RemoteEndpointImpl)r.getRequest().getAttribute(RemoteEndpointImpl.class.getName());
            return PushEndpointHandlerProxy.this.invoke(rm, originalMessage, message);
        }

        public BroadcastFilter.BroadcastAction filter(String broadccasterId, Object originalMessage, Object message) {
            return this.filter(originalMessage, message);
        }

        public BroadcastFilter.BroadcastAction filter(String broadccasterId, AtmosphereResource r, Object originalMessage, Object message) {
            return this.filter(r, originalMessage, message);
        }
    };

    private BroadcastFilter.BroadcastAction invoke(RemoteEndpoint r, Object originalMessage, Object message) {
        Object o = this.message(r, message);
        if (o != null) {
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, o);
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
    }

    public AnnotatedProxy configure(AtmosphereConfig config, Object c) {
        this.proxiedInstance = c;
        this.onMessageMethods = this.populateMessage(c, OnMessage.class);
        this.onCloseMethod = this.populate(c, OnClose.class);
        this.onTimeoutMethod = this.populate(c, OnClose.class);
        this.onOpenMethod = this.populate(c, OnOpen.class);
        this.onResumeMethod = this.populate(c, OnClose.class);
        this.config = config;
        this.eventBus = (EventBus)config.properties().get("evenBus");
        this.pathParams = this.pathParams(c);
        if (this.onMessageMethods.size() > 0) {
            this.populateEncoders();
            this.populateDecoders();
        }
        return this;
    }

    public void onRequest(final AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String body = IOUtils.readEntirely((AtmosphereResource)resource).toString();
        final RemoteEndpointImpl remoteEndpoint = new RemoteEndpointImpl(request, body);
        String method = request.getMethod();
        resource.getBroadcaster().getBroadcasterConfig().addFilter(this.injectEndpoint ? this.onPerMessageFilter : this.onMessageFilter);
        request.setAttribute(RemoteEndpointImpl.class.getName(), (Object)remoteEndpoint);
        if (this.onOpenMethod != null) {
            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

                public void onSuspend(AtmosphereResourceEvent event) {
                    try {
                        if (!PushEndpointHandlerProxy.this.trackedUUID.add(resource.uuid())) {
                            return;
                        }
                        event.broadcaster().removeAtmosphereResource(resource);
                        try {
                            PushEndpointHandlerProxy.this.invokeOpenOrClose(PushEndpointHandlerProxy.this.onOpenMethod, remoteEndpoint);
                        }
                        finally {
                            event.broadcaster().addAtmosphereResource(resource);
                        }
                    }
                    finally {
                        event.getResource().removeEventListener((AtmosphereResourceEventListener)this);
                    }
                }
            });
        }
        if (this.onResumeMethod != null) {
            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

                public void onResume(AtmosphereResourceEvent event) {
                    if (event.isResumedOnTimeout()) {
                        try {
                            PushEndpointHandlerProxy.this.invokeOpenOrClose(PushEndpointHandlerProxy.this.onResumeMethod, remoteEndpoint);
                        }
                        finally {
                            event.getResource().removeEventListener((AtmosphereResourceEventListener)this);
                        }
                    }
                }
            });
        }
        if (method.equalsIgnoreCase("post")) {
            resource.getRequest().body(body);
            if (!body.isEmpty()) {
                Object o = null;
                try {
                    o = this.invoke(remoteEndpoint, body);
                }
                catch (IOException e) {
                    this.logger.error("", (Throwable)e);
                }
                if (o != null) {
                    resource.getBroadcaster().broadcast(o);
                }
            } else {
                this.logger.warn("{} received an empty body", (Object)ManagedServiceInterceptor.class.getSimpleName());
            }
        }
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        RemoteEndpointImpl remoteEndpoint;
        Object o;
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        AtmosphereRequest request = r.getRequest(false);
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = request.getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast.booleanValue()) {
            r.resumeOnBroadcast(false);
            request.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)false);
        }
        if ((remoteEndpoint = (RemoteEndpointImpl)request.getAttribute(RemoteEndpointImpl.class.getName())) != null) {
            if (event.isCancelled() || event.isClosedByClient()) {
                remoteEndpoint.status().status(event.isCancelled() ? Status.STATUS.UNEXPECTED_CLOSE : Status.STATUS.CLOSED_BY_CLIENT);
                request.removeAttribute(RemoteEndpointImpl.class.getName());
                this.trackedUUID.remove(r.uuid());
                this.invokeOpenOrClose(this.onCloseMethod, remoteEndpoint);
            } else if (event.isResumedOnTimeout() || event.isResuming()) {
                remoteEndpoint.status().status(Status.STATUS.CLOSED_BY_TIMEOUT);
                request.removeAttribute(RemoteEndpointImpl.class.getName());
                this.invokeOpenOrClose(this.onTimeoutMethod, remoteEndpoint);
            } else {
                super.onStateChange(event);
            }
        }
        if (resumeOnBroadcast.booleanValue() && r.isSuspended()) {
            r.resume();
        }
    }

    public boolean pathParams() {
        return this.pathParams;
    }

    protected boolean pathParams(Object o) {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(PathParam.class)) continue;
            return true;
        }
        return false;
    }

    public Object invoke(RemoteEndpointImpl resource, Object msg) throws IOException {
        return this.message(resource, msg);
    }

    private Method populate(Object c, Class<? extends Annotation> annotation) {
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            return m;
        }
        return null;
    }

    private List<Method> populateMessage(Object c, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            Class<?>[] cls = m.getParameterTypes();
            List<Class<?>> classes = Arrays.asList(cls);
            if (classes.contains(EventBus.class)) {
                this.injectEventBus = true;
            } else if (classes.contains(RemoteEndpoint.class)) {
                this.injectEndpoint = true;
            }
            methods.add(m);
        }
        return methods;
    }

    private void populateEncoders() {
        for (Method m : this.onMessageMethods) {
            CopyOnWriteArrayList<Object> l = new CopyOnWriteArrayList<Object>();
            for (Class s : m.getAnnotation(OnMessage.class).encoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Encoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", (Object)s);
                }
            }
            this.encoders.put(m, l);
        }
    }

    private void populateDecoders() {
        for (Method m : this.onMessageMethods) {
            CopyOnWriteArrayList<Object> l = new CopyOnWriteArrayList<Object>();
            for (Class s : m.getAnnotation(OnMessage.class).decoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Decoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", (Object)s);
                }
            }
            this.decoders.put(m, l);
        }
    }

    private Object message(RemoteEndpoint resource, Object o) {
        try {
            for (Method m : this.onMessageMethods) {
                Object decoded = Invoker.decode(this.decoders.get(m), (Object)o);
                if (decoded == null) {
                    decoded = o;
                }
                Object objectToEncode = null;
                if (m.getParameterTypes().length == 3 && resource != null) {
                    objectToEncode = Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{resource, this.eventBus, decoded});
                } else if (m.getParameterTypes().length == 2 && resource != null) {
                    if (!this.injectEventBus) {
                        objectToEncode = Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{resource, decoded});
                    } else if (objectToEncode == null) {
                        objectToEncode = Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{this.eventBus, decoded});
                    }
                } else {
                    objectToEncode = Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{decoded});
                }
                if (objectToEncode == null) continue;
                return Invoker.encode(this.encoders.get(m), (Object)objectToEncode);
            }
        }
        catch (Throwable t) {
            this.logger.error("", t);
        }
        return null;
    }

    public Object target() {
        return this.proxiedInstance;
    }

    protected void invokeOpenOrClose(Method m, RemoteEndpointImpl r) {
        if (m == null) {
            return;
        }
        Object objectToEncode = null;
        if (m.getParameterTypes().length == 2) {
            Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{r, this.eventBus});
        } else if (!this.injectEventBus) {
            Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{r});
        } else if (objectToEncode == null) {
            Invoker.invokeMethod((Method)m, (Object)this.proxiedInstance, (Object[])new Object[]{this.eventBus});
        }
    }

    public String toString() {
        return "PushEndpointHandlerProxy proxy for " + this.proxiedInstance.getClass().getName();
    }
}

