/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputRenderer
extends CoreRenderer {
    protected List<SelectItem> getSelectItems(FacesContext context, UIInput component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            UISelectItems uiSelectItems;
            Object value;
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object selectItemValue = uiSelectItem.getValue();
                if (selectItemValue == null) {
                    selectItems.add(new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel(), uiSelectItem.getItemDescription(), uiSelectItem.isItemDisabled(), uiSelectItem.isItemEscaped(), uiSelectItem.isNoSelectionOption()));
                    continue;
                }
                selectItems.add((SelectItem)selectItemValue);
                continue;
            }
            if (!(child instanceof UISelectItems) || (value = (uiSelectItems = (UISelectItems)child).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                selectItems.add((SelectItem)value);
                continue;
            }
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object item = Array.get(value, i);
                    if (item instanceof SelectItem) {
                        selectItems.add((SelectItem)item);
                        continue;
                    }
                    selectItems.add(this.createSelectItem(context, uiSelectItems, item, null));
                }
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    selectItems.add(this.createSelectItem(context, uiSelectItems, map.get(key), String.valueOf(key)));
                }
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            for (Object item : collection) {
                if (item instanceof SelectItem) {
                    selectItems.add((SelectItem)item);
                    continue;
                }
                selectItems.add(this.createSelectItem(context, uiSelectItems, item, null));
            }
        }
        return selectItems;
    }

    protected SelectItem createSelectItem(FacesContext context, UISelectItems uiSelectItems, Object value, Object label) {
        boolean noSelectionOption;
        String var = (String)uiSelectItems.getAttributes().get("var");
        Map attrs = uiSelectItems.getAttributes();
        Map requestMap = context.getExternalContext().getRequestMap();
        if (var != null) {
            requestMap.put(var, value);
        }
        Object itemLabelValue = attrs.get("itemLabel");
        Object itemValue = attrs.get("itemValue");
        String description = (String)attrs.get("itemDescription");
        Object itemDisabled = attrs.get("itemDisabled");
        Object itemEscaped = attrs.get("itemLabelEscaped");
        Object noSelection = attrs.get("noSelectionOption");
        if (itemValue == null) {
            itemValue = value;
        }
        if (itemLabelValue == null) {
            itemLabelValue = label;
        }
        String itemLabel = itemLabelValue == null ? String.valueOf(value) : String.valueOf(itemLabelValue);
        boolean disabled = itemDisabled == null ? false : Boolean.valueOf(itemDisabled.toString());
        boolean escaped = itemEscaped == null ? true : Boolean.valueOf(itemEscaped.toString());
        boolean bl = noSelectionOption = noSelection == null ? false : Boolean.valueOf(noSelection.toString());
        if (var != null) {
            requestMap.remove(var);
        }
        return new SelectItem(itemValue, itemLabel, description, disabled, escaped, noSelectionOption);
    }

    protected String getOptionAsString(FacesContext context, UIComponent component, Converter converter, Object value) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            return value == null ? null : value.toString();
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Converter implicitConverter = this.findImplicitConverter(context, component);
            return implicitConverter == null ? value.toString() : implicitConverter.getAsString(context, component, value);
        }
        return converter.getAsString(context, component, value);
    }

    protected Converter findImplicitConverter(FacesContext context, UIComponent component) {
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null) {
            Class<?> valueType = ve.getType(context.getELContext());
            if (valueType.isArray()) {
                valueType = valueType.getComponentType();
            }
            if (valueType != null) {
                return context.getApplication().createConverter(valueType);
            }
        }
        return null;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            String convertableValue = submittedValue == null ? null : submittedValue.toString();
            return converter.getAsObject(context, component, convertableValue);
        }
        return submittedValue;
    }

    protected Object coerceToModelType(FacesContext ctx, Object value, Class itemValueType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, itemValueType);
        }
        catch (ELException ele) {
            newValue = value;
        }
        catch (IllegalArgumentException iae) {
            newValue = value;
        }
        return newValue;
    }

    public static boolean shouldDecode(UIComponent component) {
        boolean disabled = Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
        boolean readonly = Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly")));
        return !disabled && !readonly;
    }
}

