/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRequestBuilder {
    protected StringBuilder buffer;
    protected FacesContext context;
    private boolean preventDefault = false;

    public AjaxRequestBuilder(FacesContext context) {
        this.context = context;
        this.buffer = new StringBuilder();
    }

    public AjaxRequestBuilder init() {
        this.buffer.append("PrimeFaces.ab({");
        return this;
    }

    public AjaxRequestBuilder source(String source) {
        if (source != null) {
            this.buffer.append("s:").append("\"").append(source).append("\"");
        } else {
            this.buffer.append("s:").append("this");
        }
        return this;
    }

    public AjaxRequestBuilder form(String form) {
        if (form != null) {
            this.buffer.append(",f:\"").append(form).append("\"");
        }
        return this;
    }

    private boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public AjaxRequestBuilder process(UIComponent component, String expressions) {
        this.addExpressions(component, expressions, "p", 8);
        return this;
    }

    public AjaxRequestBuilder update(UIComponent component, String expressions) {
        this.addExpressions(component, expressions, "u", 9);
        return this;
    }

    private AjaxRequestBuilder addExpressions(UIComponent component, String expressions, String key, int options) {
        if (!this.isValueBlank(expressions)) {
            String resolvedExpressions = SearchExpressionFacade.resolveClientIds(this.context, component, expressions, options);
            this.buffer.append(",").append(key).append(":\"").append(resolvedExpressions).append("\"");
        }
        return this;
    }

    public AjaxRequestBuilder event(String event) {
        this.buffer.append(",e:\"").append(event).append("\"");
        return this;
    }

    public AjaxRequestBuilder async(boolean async) {
        if (async) {
            this.buffer.append(",a:true");
        }
        return this;
    }

    public AjaxRequestBuilder skipChildren(boolean skipChildren) {
        if (!skipChildren) {
            this.buffer.append(",sc:false");
        }
        return this;
    }

    public AjaxRequestBuilder global(boolean global) {
        if (!global) {
            this.buffer.append(",g:false");
        }
        return this;
    }

    public AjaxRequestBuilder delay(String delay) {
        if (!ComponentUtils.isValueBlank(delay) && !delay.equals("none")) {
            this.buffer.append(",d:").append(delay);
            if (this.context.isProjectStage(ProjectStage.Development)) {
                try {
                    Integer.parseInt(delay);
                }
                catch (NumberFormatException e) {
                    throw new FaceletException("Delay attribute should only take numbers or \"none\"");
                }
            }
        }
        return this;
    }

    public AjaxRequestBuilder timeout(int timeout) {
        if (timeout > 0) {
            this.buffer.append(",t:").append(timeout);
        }
        return this;
    }

    public AjaxRequestBuilder ignoreAutoUpdate(boolean ignoreAutoUpdate) {
        if (ignoreAutoUpdate) {
            this.buffer.append(",iau:true");
        }
        return this;
    }

    @Deprecated
    public AjaxRequestBuilder partialSubmit(boolean value, boolean partialSubmitSet) {
        boolean partialSubmit;
        PrimeConfiguration config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        boolean bl = partialSubmit = partialSubmitSet ? value : config.isPartialSubmitEnabled();
        if (partialSubmit) {
            this.buffer.append(",ps:true");
        }
        return this;
    }

    public AjaxRequestBuilder partialSubmit(boolean value, boolean partialSubmitSet, String partialSubmitFilter) {
        boolean partialSubmit;
        PrimeConfiguration config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        boolean bl = partialSubmit = partialSubmitSet ? value : config.isPartialSubmitEnabled();
        if (partialSubmit) {
            this.buffer.append(",ps:true");
            if (partialSubmitFilter != null) {
                this.buffer.append(",psf:\"").append(partialSubmitFilter).append("\"");
            }
        }
        return this;
    }

    public AjaxRequestBuilder resetValues(boolean value, boolean resetValuesSet) {
        boolean resetValues;
        PrimeConfiguration config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        boolean bl = resetValues = resetValuesSet ? value : config.isResetValuesEnabled();
        if (resetValues) {
            this.buffer.append(",rv:true");
        }
        return this;
    }

    public AjaxRequestBuilder onstart(String onstart) {
        if (onstart != null) {
            this.buffer.append(",onst:function(cfg){").append(onstart).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onerror(String onerror) {
        if (onerror != null) {
            this.buffer.append(",oner:function(xhr,status,error){").append(onerror).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onsuccess(String onsuccess) {
        if (onsuccess != null) {
            this.buffer.append(",onsu:function(data,status,xhr){").append(onsuccess).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder oncomplete(String oncomplete) {
        if (oncomplete != null) {
            this.buffer.append(",onco:function(xhr,status,args){").append(oncomplete).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder params(UIComponent component) {
        boolean paramWritten = false;
        for (UIComponent child : component.getChildren()) {
            UIParameter parameter;
            Object paramValue;
            if (!(child instanceof UIParameter) || (paramValue = (parameter = (UIParameter)child).getValue()) == null) continue;
            if (!paramWritten) {
                paramWritten = true;
                this.buffer.append(",pa:[");
            } else {
                this.buffer.append(",");
            }
            this.buffer.append("{name:").append("\"").append(parameter.getName()).append("\",value:\"").append(paramValue).append("\"}");
        }
        if (paramWritten) {
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder params(Map<String, List<String>> params) {
        if (params != null && !params.isEmpty()) {
            this.buffer.append(",pa:[");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                List<String> paramValues = params.get(name);
                int size = paramValues.size();
                for (int i = 0; i < size; ++i) {
                    String paramValue = paramValues.get(i);
                    if (paramValue == null) {
                        paramValue = "";
                    }
                    this.buffer.append("{name:").append("\"").append(name).append("\",value:\"").append(paramValue).append("\"}");
                    if (i >= size - 1) continue;
                    this.buffer.append(",");
                }
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder passParams() {
        this.buffer.append(",pa:arguments[0]");
        return this;
    }

    public AjaxRequestBuilder preventDefault() {
        this.preventDefault = true;
        return this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String build() {
        this.addFragmentConfig();
        this.buffer.append("});");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public String buildBehavior(ClientBehaviorRenderingMode mode) {
        this.addFragmentConfig();
        if (mode.equals((Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE)) {
            this.buffer.append("},ext);");
        } else if (mode.equals((Object)ClientBehaviorRenderingMode.OBSTRUSIVE)) {
            this.buffer.append("});");
        }
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public void reset() {
        this.buffer.setLength(0);
        this.preventDefault = false;
    }

    private void addFragmentConfig() {
        Map<Object, Object> attrs = RequestContext.getCurrentInstance().getAttributes();
        Object fragmentId = attrs.get("primefaces.fragment");
        if (fragmentId != null) {
            this.buffer.append(",fi:\"").append(fragmentId).append("\"");
            if (attrs.containsKey("primefaces.fragment.autorendered")) {
                this.buffer.append(",fu:true");
            }
        }
    }
}

