/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static final String RENDERER_SCRIPT = "javax.faces.resource.Script";
    public static final String RENDERER_STYLESHEET = "javax.faces.resource.Stylesheet";

    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("javax.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static void addComponentResource(FacesContext context, String name, String library) {
        ResourceUtils.addComponentResource(context, name, library, "head");
    }

    public static void addComponentResource(FacesContext context, String name) {
        ResourceUtils.addComponentResource(context, name, "primefaces", "head");
    }

    public static boolean isScript(UIComponent component) {
        return RENDERER_SCRIPT.equals(component.getRendererType());
    }

    public static boolean isStylesheet(UIComponent component) {
        return RENDERER_STYLESHEET.equals(component.getRendererType());
    }

    public static ArrayList<ResourceInfo> getComponentResources(FacesContext context) {
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        List resources = context.getViewRoot().getComponentResources(context, "head");
        if (resources != null) {
            for (UIComponent resource : resources) {
                ResourceInfo resourceInfo = ResourceUtils.newResourceInfo(resource);
                if (resourceInfo == null || resourceInfos.contains(resourceInfo)) continue;
                resourceInfos.add(resourceInfo);
            }
        }
        return resourceInfos;
    }

    public static ArrayList<String> filterStylesheets(FacesContext context, ArrayList<ResourceInfo> resourceInfos) {
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            return null;
        }
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        ArrayList<String> stylesheets = new ArrayList<String>();
        for (ResourceInfo resourceInfo : resourceInfos) {
            if (!ResourceUtils.isStylesheet(resourceInfo.getResource())) continue;
            Resource resource = ComponentUtils.isValueBlank(resourceInfo.getLibrary()) ? resourceHandler.createResource(resourceInfo.getName()) : resourceHandler.createResource(resourceInfo.getName(), resourceInfo.getLibrary());
            stylesheets.add(resource.getRequestPath());
        }
        return stylesheets;
    }

    public static ArrayList<String> filterScripts(FacesContext context, ArrayList<ResourceInfo> resourceInfos) {
        if (resourceInfos == null || resourceInfos.isEmpty()) {
            return null;
        }
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        ArrayList<String> scripts = new ArrayList<String>();
        for (ResourceInfo resourceInfo : resourceInfos) {
            if (!ResourceUtils.isScript(resourceInfo.getResource())) continue;
            Resource resource = ComponentUtils.isValueBlank(resourceInfo.getLibrary()) ? resourceHandler.createResource(resourceInfo.getName()) : resourceHandler.createResource(resourceInfo.getName(), resourceInfo.getLibrary());
            scripts.add(resource.getRequestPath());
        }
        return scripts;
    }

    public static ResourceInfo newResourceInfo(UIComponent component) {
        if (!(component instanceof UIOutput)) {
            return null;
        }
        String library = (String)component.getAttributes().get("library");
        String name = (String)component.getAttributes().get("name");
        return new ResourceInfo(library, name, component);
    }

    public static Resource newResource(ResourceInfo resourceInfo, FacesContext context) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceInfo.getName(), resourceInfo.getLibrary());
        if (resource == null) {
            throw new FacesException("Resource '" + resourceInfo.getName() + "' in library '" + resourceInfo.getLibrary() + "' not found!");
        }
        return resource;
    }

    public static class ResourceInfo
    implements Serializable {
        private String library;
        private String name;
        private UIComponent resource;

        public ResourceInfo(String library, String name, UIComponent resource) {
            this.library = library;
            this.name = name;
            this.resource = resource;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setLibrary(String library) {
            this.library = library;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UIComponent getResource() {
            return this.resource;
        }

        public void setResource(UIComponent resource) {
            this.resource = resource;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.library != null ? this.library.hashCode() : 0);
            hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceInfo other = (ResourceInfo)obj;
            if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

