package org.ait.controller;

import java.util.Date;
import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.ait.model.Book;

@Stateless
public class BookBean implements BookBeanLocal {

	@PersistenceContext(unitName = "JPAExampleDB")
	private EntityManager entityManager;

	public BookBean() {

	}

	@Override
	public void saveBook(long isbn, String title, String author, Date releaseDate, String format) {
		Book b1 = new Book();
		b1.setIsbn(isbn);
		b1.setTitle(title);
		b1.setAuthor(author);
		b1.setReleaseyear(releaseDate);
		b1.setFormat(format);
		
		entityManager.persist(b1);
	}

	@Override
	public String findBook(long isbn) {
		Book b = entityManager.find(Book.class, isbn);
		return b.getAuthor();
	}

	/*
	@Override
	public List<Book> retrieveAllBooks() {
		String q = "SELECT b from" + Book.class.getName() + " p";
		Query query = entityManager.createQuery(q);
		List<Book> books = query.getResultList();
		return books;
	}
	*/
}
