﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UnitTest
{
    public class Magazin
    {
        public int Periodus { get; set; }

        public int PeriodusAr { get; set; }

        public double EuroAr { get; set; }


        public Magazin(int periodus, int periodusAr, double euroAr)
        {
            this.Periodus = periodus;
            this.PeriodusAr = periodusAr;
            this.EuroAr = euroAr;
        }

        public int HaviAr
        {
            get
            {
                if (this.Periodus <= 0)
                {
                    throw new Exception("A periodusnak nagyobbnak kell lenni-e nullánál.");
                }

                if (this.PeriodusAr <= 0)
                {
                    throw new Exception("Az árnak nagyobbnak kell lenni-e nullánál.");
                }

                double haviar = this.PeriodusAr / this.Periodus;
                int haviArAsInt = this.KerekitForint(haviar);
                return haviArAsInt;
            }
        }

        public int KerekitForint(double ar)
        {
            ar = Math.Round(ar, MidpointRounding.AwayFromZero);
            int egeszResz = (int)ar;

            int maradek = egeszResz % 5;
            if (maradek == 0)
            {
                return egeszResz;
            }
            else if (maradek == 1)
            {
                return egeszResz - 1;
            }
            else if (maradek == 2)
            {
                return egeszResz - 2;
            }
            else if (maradek == 3)
            {
                return egeszResz + 2;
            }
            else// maradek = 4
            {
                return egeszResz + 1;
            }
        }

        public double AtvaltasForintrolEurora(int ar)
        {
            double arEuroban = ar / this.EuroAr;
            return arEuroban;
        }

        public double KerekitesKetTizedesJegyre(double szam)
        {
            return Math.Round(szam, 2, MidpointRounding.AwayFromZero);
        }
    }

}
