public class Magazin {
	private int Periodus;
	private int PeriodusAr;
	private double EuroAr;
	
	public Magazin(int periodus, int periodusAr, double euroAr)
	{
		super();
		this.Periodus = periodus;
		this.PeriodusAr = periodusAr;
		this.EuroAr = euroAr;
	}
	public int getPeriodus()
	{
		return Periodus;
	}
	public void setPeriodus(int periodus)
	{
		Periodus = periodus;
	}
	public int getPeriodusAr()
	{
		return PeriodusAr;
	}
	public void setPeriodusAr(int periodusAr)
	{
		PeriodusAr = periodusAr;
	}
	
	public int GetHaviAr() throws Exception
	{
		if (this.Periodus <= 0)
		{
			throw new Exception("A periodusnak nagyobbnak kell lenni-e nullnl.");
		}
		
		if (this.PeriodusAr <= 0)
		{
			throw new Exception("Az rnak nagyobbnak kell lenni-e nullnl.");
		}
		
		double haviar = this.PeriodusAr / this.Periodus;
		int haviArAsInt = this.KerekitForint(haviar);
		return haviArAsInt;
	}
	
	public int KerekitForint(double ar)
	{
		int egeszResz = (int)ar;
		double tortResz = ar - (double)egeszResz;
		if ( tortResz >= 0.5)
		{
			egeszResz++;
		}
		
		int maradek = egeszResz % 5;
		if (maradek == 0)
		{
			return egeszResz;
		}
		else if (maradek == 1)
		{
			return egeszResz - 1;
		}
		else if (maradek == 2)
		{
			return egeszResz - 2;
		}
		else if (maradek == 3)
		{
			return egeszResz + 2;
		}
		else// maradek = 4
		{
			return egeszResz + 1;
		}
	}
	
	public double AtvaltasForintrolEurora(int ar)
	{
		double arEuroban = ar / this.EuroAr;
		return arEuroban;
	}
	
	public double KerekitesKetTizedesJegyre(double szam)
	{
		int egeszResz = (int)szam;
		double tortResz = szam - (double)egeszResz;
		
		int ezredKetTizedesResze = (int)(tortResz * 100);
		double ezredMaradekResze = tortResz * 100;
		if (ezredMaradekResze >= 0.5)
		{
			ezredKetTizedesResze += 1;
		}
		
		double arEuroban = (double)egeszResz + (double)ezredKetTizedesResze / 100;
		return arEuroban;
	}
}
