/**
 * 
 */
package org.ait.mediator;

import javax.swing.DefaultListModel;


class Mediator {
	/**
	 * 
	 */
	private final FTPGUI Mediator;

	/**
	 * @param ftpgui
	 */
	Mediator(FTPGUI ftpgui) {
		Mediator = ftpgui;
	}

	private UploadButton btnUpload;

	private DownloadButton btnDownload;

	private DeleteButton btnDelete;

	private LocalList localList;

	private RemoteList remoteList;

	public void registerUploadButton(UploadButton inp_ib) {
		btnUpload = inp_ib;
	}

	public void registerDownloadButton(DownloadButton inp_dnb) {
		btnDownload = inp_dnb;
	}

	public void registerDeleteButton(DeleteButton inp_db) {
		btnDelete = inp_db;
	}

	public void registerLocalList(LocalList inp_arl) {
		localList = inp_arl;
	}

	public void registerRemoteList(RemoteList inp_drl) {
		remoteList = inp_drl;
	}

	public void UploadItem() {

		int index = localList.getSelectedIndex();
		String selectedItem = localList.getSelectedValue().toString();
		((DefaultListModel) localList.getModel()).remove(index);

		((DefaultListModel) remoteList.getModel()).addElement(selectedItem);

		btnUpload.setEnabled(false);
		btnDelete.setEnabled(false);
		btnDownload.setEnabled(false);
	}

	public void DownloadItem() {
		int index = remoteList.getSelectedIndex();
		String selectedItem = remoteList.getSelectedValue().toString();
		((DefaultListModel) remoteList.getModel()).remove(index);

		((DefaultListModel) localList.getModel()).addElement(selectedItem);

		btnUpload.setEnabled(false);
		btnDelete.setEnabled(false);
		btnDownload.setEnabled(false);
	}

	public void DeleteItem() {
		int index = localList.getSelectedIndex();
		if (index >= 0) {
			((DefaultListModel) localList.getModel()).remove(index);
		}

		index = remoteList.getSelectedIndex();
		if (index >= 0) {
			((DefaultListModel) remoteList.getModel()).remove(index);
		}
		btnUpload.setEnabled(false);
		btnDelete.setEnabled(false);
		btnDownload.setEnabled(false);

	}

	public void LocalListSelect() {
		remoteList.setSelectedIndex(-1);
		btnUpload.setEnabled(true);
		btnDelete.setEnabled(true);
		btnDownload.setEnabled(false);
	}

	public void RemoteListSelect() {
		localList.setSelectedIndex(-1);
		btnUpload.setEnabled(false);
		btnDelete.setEnabled(true);
		btnDownload.setEnabled(true);
	}
}